/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.screenrecorder;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.SwingUtilities;
import ru.sbtqa.monte.media.AudioFormatKeys;
import ru.sbtqa.monte.media.Buffer;
import ru.sbtqa.monte.media.BufferFlag;
import ru.sbtqa.monte.media.Codec;
import ru.sbtqa.monte.media.Format;
import ru.sbtqa.monte.media.FormatKeys;
import ru.sbtqa.monte.media.MovieWriter;
import ru.sbtqa.monte.media.Registry;
import ru.sbtqa.monte.media.VideoFormatKeys;
import ru.sbtqa.monte.media.avi.AVIWriter;
import ru.sbtqa.monte.media.beans.AbstractStateModel;
import ru.sbtqa.monte.media.color.Colors;
import ru.sbtqa.monte.media.converter.CodecChain;
import ru.sbtqa.monte.media.converter.ScaleImageCodec;
import ru.sbtqa.monte.media.image.Images;
import ru.sbtqa.monte.media.math.Rational;
import ru.sbtqa.monte.media.quicktime.QuickTimeWriter;

public class ScreenRecorder
extends AbstractStateModel {
    private State state = State.DONE;
    private Throwable stateMessage = null;
    public static final String ENCODING_BLACK_CURSOR = "black";
    public static final String ENCODING_WHITE_CURSOR = "white";
    public static final String ENCODING_YELLOW_CURSOR = "yellow";
    private Format fileFormat;
    protected Format mouseFormat;
    private Format screenFormat;
    private Format audioFormat;
    private Rectangle captureArea;
    private MovieWriter w;
    protected long recordingStartTime;
    protected volatile long recordingStopTime;
    private long fileStartTime;
    private ArrayBlockingQueue<Buffer> mouseCaptures;
    private ScheduledThreadPoolExecutor screenCaptureTimer;
    protected ScheduledThreadPoolExecutor mouseCaptureTimer;
    private ScheduledThreadPoolExecutor audioCaptureTimer;
    private volatile Thread writerThread;
    private BufferedImage cursorImg;
    private BufferedImage cursorImgPressed;
    private Point cursorOffset;
    private final Object sync = new Object();
    private ArrayBlockingQueue<Buffer> writerQueue;
    private Codec frameEncoder;
    private Rational outputTime;
    private Rational ffrDuration;
    private ArrayList<File> recordedFiles;
    protected int videoTrack = 0;
    protected int audioTrack = 1;
    private GraphicsDevice captureDevice;
    private AudioGrabber audioGrabber;
    private ScreenGrabber screenGrabber;
    protected MouseGrabber mouseGrabber;
    private ScheduledFuture<?> audioFuture;
    private ScheduledFuture<?> screenFuture;
    protected ScheduledFuture<?> mouseFuture;
    protected File movieFolder;
    private AWTEventListener awtEventListener;
    private long maxRecordingTime = 3600000L;
    private long maxFileSize = Long.MAX_VALUE;
    private Mixer mixer;
    long counter = 0L;

    public ScreenRecorder(GraphicsConfiguration cfg) throws IOException, AWTException {
        this(cfg, null, new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, VideoFormatKeys.MimeTypeKey, "video/quicktime"}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, "rle ", VideoFormatKeys.CompressorNameKey, "Animation", VideoFormatKeys.DepthKey, 24, VideoFormatKeys.FrameRateKey, new Rational(15L, 1L)}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, ENCODING_BLACK_CURSOR, VideoFormatKeys.FrameRateKey, new Rational(30L, 1L)}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, VideoFormatKeys.EncodingKey, "twos", VideoFormatKeys.FrameRateKey, new Rational(48000L, 1L), AudioFormatKeys.SampleSizeInBitsKey, 16, AudioFormatKeys.ChannelsKey, 2, AudioFormatKeys.SampleRateKey, new Rational(48000L, 1L), AudioFormatKeys.SignedKey, true, AudioFormatKeys.ByteOrderKey, ByteOrder.BIG_ENDIAN}));
    }

    public ScreenRecorder(GraphicsConfiguration cfg, Format fileFormat, Format screenFormat, Format mouseFormat, Format audioFormat) throws IOException, AWTException {
        this(cfg, null, fileFormat, screenFormat, mouseFormat, audioFormat);
    }

    public ScreenRecorder(GraphicsConfiguration cfg, Rectangle captureArea, Format fileFormat, Format screenFormat, Format mouseFormat, Format audioFormat) throws IOException, AWTException {
        this(cfg, null, fileFormat, screenFormat, mouseFormat, audioFormat, null);
    }

    public ScreenRecorder(GraphicsConfiguration cfg, Rectangle captureArea, Format fileFormat, Format screenFormat, Format mouseFormat, Format audioFormat, File movieFolder) throws IOException, AWTException {
        this.fileFormat = fileFormat;
        this.screenFormat = screenFormat;
        this.mouseFormat = mouseFormat;
        if (this.mouseFormat == null) {
            this.mouseFormat = new Format(VideoFormatKeys.FrameRateKey, new Rational(0L, 0L), VideoFormatKeys.EncodingKey, ENCODING_BLACK_CURSOR);
        }
        this.audioFormat = audioFormat;
        this.recordedFiles = new ArrayList();
        this.captureDevice = cfg.getDevice();
        Rectangle rectangle = this.captureArea = captureArea == null ? cfg.getBounds() : captureArea;
        if (mouseFormat != null && ((Rational)mouseFormat.get(VideoFormatKeys.FrameRateKey)).intValue() > 0) {
            this.mouseCaptures = new ArrayBlockingQueue(((Rational)mouseFormat.get(VideoFormatKeys.FrameRateKey)).intValue() * 2);
            if (((String)this.mouseFormat.get(VideoFormatKeys.EncodingKey)).equals(ENCODING_BLACK_CURSOR)) {
                this.cursorImg = Images.toBufferedImage(Images.createImage(ScreenRecorder.class, "images/Cursor.black.png"));
                this.cursorImgPressed = Images.toBufferedImage(Images.createImage(ScreenRecorder.class, "images/Cursor.black.pressed.png"));
            } else if (((String)this.mouseFormat.get(VideoFormatKeys.EncodingKey)).equals(ENCODING_YELLOW_CURSOR)) {
                this.cursorImg = Images.toBufferedImage(Images.createImage(ScreenRecorder.class, "images/Cursor.yellow.png"));
                this.cursorImgPressed = Images.toBufferedImage(Images.createImage(ScreenRecorder.class, "images/Cursor.yellow.pressed.png"));
            } else {
                this.cursorImg = Images.toBufferedImage(Images.createImage(ScreenRecorder.class, "images/Cursor.white.png"));
                this.cursorImgPressed = Images.toBufferedImage(Images.createImage(ScreenRecorder.class, "images/Cursor.white.pressed.png"));
            }
            this.cursorOffset = new Point(this.cursorImg.getWidth() / -2, this.cursorImg.getHeight() / -2);
        }
        this.movieFolder = movieFolder;
        if (this.movieFolder == null) {
            this.movieFolder = System.getProperty("os.name").toLowerCase().startsWith("windows") ? new File(System.getProperty("user.home") + File.separator + "Videos") : new File(System.getProperty("user.home") + File.separator + "Movies");
        }
    }

    protected MovieWriter createMovieWriter() throws IOException {
        Codec encoder;
        File f = this.createMovieFile(this.fileFormat);
        this.recordedFiles.add(f);
        MovieWriter mw = this.w = Registry.getInstance().getWriter(this.fileFormat, f);
        Rational videoRate = Rational.max((Rational)this.screenFormat.get(VideoFormatKeys.FrameRateKey), (Rational)this.mouseFormat.get(VideoFormatKeys.FrameRateKey));
        this.ffrDuration = videoRate.inverse();
        Format videoInputFormat = this.screenFormat.prepend(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, "image", VideoFormatKeys.WidthKey, this.captureArea.width, VideoFormatKeys.HeightKey, this.captureArea.height, VideoFormatKeys.FrameRateKey, videoRate});
        Format videoOutputFormat = this.screenFormat.prepend(VideoFormatKeys.FrameRateKey, videoRate, VideoFormatKeys.MimeTypeKey, this.fileFormat.get(VideoFormatKeys.MimeTypeKey)).append(VideoFormatKeys.WidthKey, this.captureArea.width, VideoFormatKeys.HeightKey, this.captureArea.height);
        this.videoTrack = this.w.addTrack(videoOutputFormat);
        if (this.audioFormat != null) {
            this.audioTrack = this.w.addTrack(this.audioFormat);
        }
        if ((encoder = Registry.getInstance().getEncoder(this.w.getFormat(this.videoTrack))) == null) {
            throw new IOException("No encoder for format " + this.w.getFormat(this.videoTrack));
        }
        this.frameEncoder = encoder;
        this.frameEncoder.setInputFormat(videoInputFormat);
        this.frameEncoder.setOutputFormat(videoOutputFormat);
        if (this.frameEncoder.getOutputFormat() == null) {
            throw new IOException("Unable to encode video frames in this output format:\n" + videoOutputFormat);
        }
        if (!videoInputFormat.intersectKeys(VideoFormatKeys.WidthKey, VideoFormatKeys.HeightKey).matches(videoOutputFormat.intersectKeys(VideoFormatKeys.WidthKey, VideoFormatKeys.HeightKey))) {
            ScaleImageCodec sic = new ScaleImageCodec();
            sic.setInputFormat(videoInputFormat);
            sic.setOutputFormat(videoOutputFormat.intersectKeys(VideoFormatKeys.WidthKey, VideoFormatKeys.HeightKey).append(videoInputFormat));
            this.frameEncoder = new CodecChain(sic, this.frameEncoder);
        }
        if (this.screenFormat.get(VideoFormatKeys.DepthKey) == 8) {
            if (this.w instanceof AVIWriter) {
                AVIWriter aviw = (AVIWriter)this.w;
                aviw.setPalette(this.videoTrack, Colors.createMacColors());
            } else if (this.w instanceof QuickTimeWriter) {
                QuickTimeWriter qtw = (QuickTimeWriter)this.w;
                qtw.setVideoColorTable(this.videoTrack, Colors.createMacColors());
            }
        }
        this.fileStartTime = System.currentTimeMillis();
        return mw;
    }

    public List<File> getCreatedMovieFiles() {
        return Collections.unmodifiableList(this.recordedFiles);
    }

    protected File createMovieFile(Format fileFormat) throws IOException {
        if (!this.movieFolder.exists()) {
            this.movieFolder.mkdirs();
        } else if (!this.movieFolder.isDirectory()) {
            throw new IOException("\"" + this.movieFolder + "\" is not a directory.");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd 'at' HH.mm.ss");
        File f = new File(this.movieFolder, "ScreenRecording " + dateFormat.format(new Date()) + "." + Registry.getInstance().getExtension(fileFormat));
        return f;
    }

    public State getState() {
        return this.state;
    }

    public Throwable getStateMessage() {
        return this.stateMessage;
    }

    private void setState(State newValue, Throwable msg) {
        this.state = newValue;
        this.stateMessage = msg;
        this.fireStateChanged();
    }

    public long getStartTime() {
        return this.recordingStartTime;
    }

    public void start() throws IOException {
        this.stop();
        this.recordedFiles.clear();
        this.createMovieWriter();
        try {
            this.recordingStartTime = System.currentTimeMillis();
            this.recordingStopTime = Long.MAX_VALUE;
            this.outputTime = new Rational(0L, 0L);
            this.startWriter();
            try {
                this.startScreenCapture();
            }
            catch (AWTException e) {
                IOException ioe = new IOException("Start screen capture failed");
                ioe.initCause(e);
                this.stop();
                throw ioe;
            }
            catch (IOException ioe) {
                this.stop();
                throw ioe;
            }
            if (this.mouseFormat != null && ((Rational)this.mouseFormat.get(VideoFormatKeys.FrameRateKey)).intValue() > 0) {
                this.startMouseCapture();
            }
            if (this.audioFormat != null) {
                try {
                    this.startAudioCapture();
                }
                catch (LineUnavailableException e) {
                    IOException ioe = new IOException("Start audio capture failed");
                    ioe.initCause(e);
                    this.stop();
                    throw ioe;
                }
            }
            this.setState(State.RECORDING, null);
        }
        catch (IOException e) {
            this.setState(State.FAILING, e);
            this.stop();
            throw e;
        }
        catch (Throwable t) {
            this.setState(State.FAILING, t);
            this.stop();
            throw new IOException(t);
        }
    }

    private void startScreenCapture() throws AWTException, IOException {
        this.screenCaptureTimer = new ScheduledThreadPoolExecutor(1);
        int delay = Math.max(1, (int)(1000.0 / ((Rational)this.screenFormat.get(VideoFormatKeys.FrameRateKey)).doubleValue()));
        this.screenGrabber = new ScreenGrabber(this, this.recordingStartTime);
        this.screenFuture = this.screenCaptureTimer.scheduleAtFixedRate(this.screenGrabber, delay, delay, TimeUnit.MILLISECONDS);
        this.screenGrabber.setFuture(this.screenFuture);
    }

    private void stopScreenCapture() {
        if (this.screenCaptureTimer != null) {
            this.screenGrabber.setStopTime(this.recordingStopTime);
        }
    }

    private void abortScreenCapture() {
        if (this.screenCaptureTimer != null) {
            this.screenGrabber.setStopTime(this.recordingStopTime);
            this.screenCaptureTimer.shutdownNow();
        }
    }

    protected void startMouseCapture() throws IOException {
        this.mouseCaptureTimer = new ScheduledThreadPoolExecutor(1);
        int delay = Math.max(1, (int)(1000.0 / ((Rational)this.mouseFormat.get(VideoFormatKeys.FrameRateKey)).doubleValue()));
        this.mouseGrabber = new MouseGrabber(this, this.recordingStartTime, this.mouseCaptureTimer);
        this.mouseFuture = this.mouseCaptureTimer.scheduleAtFixedRate(this.mouseGrabber, delay, delay, TimeUnit.MILLISECONDS);
        final MouseGrabber mouseGrabberF = this.mouseGrabber;
        this.awtEventListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event.getID() == 501) {
                    mouseGrabberF.setMousePressed(true);
                } else if (event.getID() == 502) {
                    mouseGrabberF.setMousePressed(false);
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.awtEventListener, 16L);
        this.mouseGrabber.setFuture(this.mouseFuture);
    }

    protected void stopMouseCapture() {
        if (this.mouseCaptureTimer != null) {
            this.mouseGrabber.setStopTime(this.recordingStopTime);
        }
        if (this.awtEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtEventListener);
            this.awtEventListener = null;
        }
    }

    private void abortMouseCapture() {
        if (this.mouseCaptureTimer != null) {
            this.mouseGrabber.setStopTime(this.recordingStopTime);
            this.mouseCaptureTimer.shutdownNow();
        }
        if (this.awtEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtEventListener);
            this.awtEventListener = null;
        }
    }

    protected void waitUntilMouseCaptureStopped() throws InterruptedException {
        if (this.mouseCaptureTimer != null) {
            try {
                this.mouseFuture.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (CancellationException cancellationException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            this.mouseCaptureTimer.shutdown();
            this.mouseCaptureTimer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            this.mouseCaptureTimer = null;
            this.mouseGrabber.close();
            this.mouseGrabber = null;
        }
    }

    private void startAudioCapture() throws LineUnavailableException {
        this.audioCaptureTimer = new ScheduledThreadPoolExecutor(1);
        int delay = 500;
        this.audioGrabber = new AudioGrabber(this.mixer, this.audioFormat, this.audioTrack, this.recordingStartTime, this.writerQueue);
        this.audioFuture = this.audioCaptureTimer.scheduleWithFixedDelay(this.audioGrabber, 0L, 10L, TimeUnit.MILLISECONDS);
        this.audioGrabber.setFuture(this.audioFuture);
    }

    private void stopAudioCapture() {
        if (this.audioCaptureTimer != null) {
            this.audioGrabber.setStopTime(this.recordingStopTime);
        }
    }

    private void abortAudioCapture() {
        if (this.audioCaptureTimer != null) {
            this.audioGrabber.setStopTime(this.recordingStopTime);
            this.audioCaptureTimer.shutdownNow();
        }
    }

    public float getAudioLevelLeft() {
        AudioGrabber ag = this.audioGrabber;
        if (ag != null) {
            return ag.getAudioLevelLeft();
        }
        return -1.0f;
    }

    public float getAudioLevelRight() {
        AudioGrabber ag = this.audioGrabber;
        if (ag != null) {
            return ag.getAudioLevelRight();
        }
        return -1.0f;
    }

    private void startWriter() {
        this.writerQueue = new ArrayBlockingQueue(Math.max(((Rational)this.screenFormat.get(VideoFormatKeys.FrameRateKey)).intValue(), ((Rational)this.mouseFormat.get(VideoFormatKeys.FrameRateKey)).intValue()) + 1);
        this.writerThread = new Thread(){

            @Override
            public void run() {
                try {
                    while (ScreenRecorder.this.writerThread == this || !ScreenRecorder.this.writerQueue.isEmpty()) {
                        try {
                            Buffer buf = (Buffer)ScreenRecorder.this.writerQueue.take();
                            ScreenRecorder.this.doWrite(buf);
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                    }
                }
                catch (Throwable e) {
                    ScreenRecorder.this.recordingFailed(e);
                }
            }
        };
        this.writerThread.start();
    }

    private void recordingFailed(final Throwable msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ScreenRecorder.this.stop();
                    ScreenRecorder.this.setState(State.FAILED, msg);
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
        });
    }

    public void stop() throws IOException {
        if (this.state == State.RECORDING || this.state == State.FAILING) {
            block12: {
                this.recordingStopTime = System.currentTimeMillis();
                this.stopMouseCapture();
                this.stopScreenCapture();
                this.stopAudioCapture();
                try {
                    this.waitUntilMouseCaptureStopped();
                    if (this.screenCaptureTimer != null) {
                        try {
                            this.screenFuture.get();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (CancellationException cancellationException) {
                        }
                        catch (ExecutionException executionException) {
                            // empty catch block
                        }
                        this.screenCaptureTimer.shutdown();
                        this.screenCaptureTimer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                        this.screenCaptureTimer = null;
                        this.screenGrabber.close();
                        this.screenGrabber = null;
                    }
                    if (this.audioCaptureTimer == null) break block12;
                    try {
                        this.audioFuture.get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (CancellationException cancellationException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    this.audioCaptureTimer.shutdown();
                    this.audioCaptureTimer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                    this.audioCaptureTimer = null;
                    this.audioGrabber.close();
                    this.audioGrabber = null;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.stopWriter();
            this.setState(this.state == State.FAILING ? State.FAILED : State.DONE, this.getStateMessage());
        }
    }

    private void stopWriter() throws IOException {
        Thread pendingWriterThread = this.writerThread;
        this.writerThread = null;
        try {
            if (pendingWriterThread != null) {
                pendingWriterThread.interrupt();
                pendingWriterThread.join();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        if (this.w != null) {
            this.w.close();
            this.w = null;
        }
    }

    public void abort() throws IOException {
        if (this.state == State.RECORDING || this.state == State.FAILING) {
            this.setState(State.FAILING, null);
            this.recordingStopTime = this.recordingStartTime;
            this.abortMouseCapture();
            this.abortScreenCapture();
            this.abortAudioCapture();
            this.stopWriter();
            this.setState(this.state == State.FAILING ? State.FAILED : State.DONE, this.getStateMessage());
        }
    }

    protected void write(Buffer buf) throws IOException, InterruptedException {
        MovieWriter writer = this.w;
        if (writer == null) {
            return;
        }
        if (buf.track == this.videoTrack) {
            if (!writer.getFormat(this.videoTrack).get(VideoFormatKeys.FixedFrameRateKey, false).booleanValue()) {
                Buffer wbuf = new Buffer();
                this.frameEncoder.process(buf, wbuf);
                this.writerQueue.put(wbuf);
            } else {
                Rational inputTime = buf.timeStamp.add(buf.sampleDuration);
                boolean isFirst = true;
                while (this.outputTime.compareTo(inputTime) < 0) {
                    buf.timeStamp = this.outputTime;
                    buf.sampleDuration = this.ffrDuration;
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        buf.setFlag(BufferFlag.SAME_DATA);
                    }
                    Buffer wbuf = new Buffer();
                    if (this.frameEncoder.process(buf, wbuf) != 0) {
                        throw new IOException("Codec failed or could not process frame in a single step.");
                    }
                    this.writerQueue.put(wbuf);
                    this.outputTime = this.outputTime.add(this.ffrDuration);
                }
            }
        } else {
            Buffer wbuf = new Buffer();
            wbuf.setMetaTo(buf);
            wbuf.data = ((byte[])buf.data).clone();
            wbuf.length = buf.length;
            wbuf.offset = buf.offset;
            this.writerQueue.put(wbuf);
        }
    }

    private void doWrite(Buffer buf) throws IOException {
        MovieWriter mw = this.w;
        long now = System.currentTimeMillis();
        if (buf.track == this.videoTrack && buf.isFlag(BufferFlag.KEYFRAME) && (mw.isDataLimitReached() || now - this.fileStartTime > this.maxRecordingTime)) {
            final MovieWriter closingWriter = mw;
            new Thread(){

                @Override
                public void run() {
                    try {
                        closingWriter.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }.start();
            mw = this.createMovieWriter();
        }
        mw.write(buf.track, buf);
    }

    public long getMaxRecordingTime() {
        return this.maxRecordingTime;
    }

    public void setMaxRecordingTime(long maxRecordingTime) {
        this.maxRecordingTime = maxRecordingTime;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public Mixer getAudioMixer() {
        return this.mixer;
    }

    public void setAudioMixer(Mixer mixer) {
        this.mixer = mixer;
    }

    private static class AudioGrabber
    implements Runnable {
        private final TargetDataLine line;
        private final BlockingQueue<Buffer> queue;
        private final Format audioFormat;
        private final int audioTrack;
        private final long startTime;
        private volatile long stopTime = Long.MAX_VALUE;
        private long totalSampleCount;
        private ScheduledFuture<?> future;
        private long sequenceNumber;
        private float audioLevelLeft = -1.0f;
        private float audioLevelRight = -1.0f;
        private Mixer mixer;

        public AudioGrabber(Mixer mixer, Format audioFormat, int audioTrack, long startTime, BlockingQueue<Buffer> queue) throws LineUnavailableException {
            Control ctrl2;
            this.mixer = mixer;
            this.audioFormat = audioFormat;
            this.audioTrack = audioTrack;
            this.queue = queue;
            this.startTime = startTime;
            DataLine.Info lineInfo = new DataLine.Info(TargetDataLine.class, AudioFormatKeys.toAudioFormat(audioFormat));
            this.line = mixer != null ? (TargetDataLine)mixer.getLine(lineInfo) : (TargetDataLine)AudioSystem.getLine(lineInfo);
            try {
                ctrl2 = (BooleanControl)this.line.getControl(BooleanControl.Type.MUTE);
                ((BooleanControl)ctrl2).setValue(false);
            }
            catch (IllegalArgumentException ctrl2) {
                // empty catch block
            }
            try {
                ctrl2 = (FloatControl)this.line.getControl(FloatControl.Type.VOLUME);
                ((FloatControl)ctrl2).setValue(Math.max(((FloatControl)ctrl2).getValue(), 0.2f));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.line.open();
            this.line.start();
        }

        public void setFuture(ScheduledFuture<?> future) {
            this.future = future;
        }

        public void close() {
            this.line.close();
        }

        public synchronized void setStopTime(long newValue) {
            this.stopTime = newValue;
        }

        public synchronized long getStopTime() {
            return this.stopTime;
        }

        @Override
        public void run() {
            Buffer buf = new Buffer();
            AudioFormat lineFormat = this.line.getFormat();
            buf.format = AudioFormatKeys.fromAudioFormat(lineFormat).append(AudioFormatKeys.SilenceBugKey, true);
            int bufferSize = lineFormat.getFrameSize() * (int)lineFormat.getSampleRate();
            if (((int)lineFormat.getSampleRate() & 1) == 0) {
                bufferSize /= 2;
            }
            byte[] bdat = new byte[bufferSize];
            buf.data = bdat;
            Rational sampleRate = Rational.valueOf(lineFormat.getSampleRate());
            Rational frameRate = Rational.valueOf(lineFormat.getFrameRate());
            int count = this.line.read(bdat, 0, bdat.length);
            if (count > 0) {
                this.computeAudioLevel(bdat, count, lineFormat);
                buf.sampleCount = count / (lineFormat.getSampleSizeInBits() / 8 * lineFormat.getChannels());
                buf.sampleDuration = sampleRate.inverse();
                buf.offset = 0;
                buf.sequenceNumber = this.sequenceNumber++;
                buf.length = count;
                buf.track = this.audioTrack;
                buf.timeStamp = new Rational(this.totalSampleCount, 1L).divide(frameRate);
                Rational stopTS = new Rational(this.getStopTime() - this.startTime, 1000L);
                if (buf.timeStamp.add(buf.sampleDuration.multiply(buf.sampleCount)).compareTo(stopTS) > 0) {
                    buf.sampleCount = Math.max(0, (int)Math.ceil(stopTS.subtract(buf.timeStamp).divide(buf.sampleDuration).floatValue()));
                    buf.length = buf.sampleCount * (lineFormat.getSampleSizeInBits() / 8 * lineFormat.getChannels());
                    this.future.cancel(false);
                }
                if (buf.sampleCount > 0) {
                    try {
                        this.queue.put(buf);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.totalSampleCount += (long)buf.sampleCount;
            }
        }

        private void computeAudioLevel(byte[] data, int length, AudioFormat format) {
            this.audioLevelRight = -1.0f;
            this.audioLevelLeft = -1.0f;
            if (format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                block0 : switch (format.getSampleSizeInBits()) {
                    case 8: {
                        switch (format.getChannels()) {
                            case 1: {
                                this.audioLevelLeft = this.computeAudioLevelSigned8(data, 0, length, format.getFrameSize());
                                break;
                            }
                            case 2: {
                                this.audioLevelLeft = this.computeAudioLevelSigned8(data, 0, length, format.getFrameSize());
                                this.audioLevelRight = this.computeAudioLevelSigned8(data, 1, length, format.getFrameSize());
                            }
                        }
                        break;
                    }
                    case 16: {
                        if (format.isBigEndian()) {
                            switch (format.getChannels()) {
                                case 1: {
                                    this.audioLevelLeft = this.computeAudioLevelSigned16BE(data, 0, length, format.getFrameSize());
                                    break;
                                }
                                case 2: {
                                    this.audioLevelLeft = this.computeAudioLevelSigned16BE(data, 0, length, format.getFrameSize());
                                    this.audioLevelRight = this.computeAudioLevelSigned16BE(data, 2, length, format.getFrameSize());
                                }
                            }
                            break;
                        }
                        switch (format.getChannels()) {
                            case 1: {
                                break block0;
                            }
                        }
                    }
                }
            }
        }

        private float computeAudioLevelSigned16BE(byte[] data, int offset, int length, int stride) {
            double sum = 0.0;
            for (int i = offset; i < length; i += stride) {
                int value = data[i] << 8 | data[i + 1] & 0xFF;
                sum += (double)(value * value);
            }
            double rms = Math.sqrt(sum / (double)((length - offset) / stride));
            return (float)(rms / 32768.0);
        }

        private float computeAudioLevelSigned8(byte[] data, int offset, int length, int stride) {
            double sum = 0.0;
            for (int i = offset; i < length; i += stride) {
                byte value = data[i];
                if (value == -128) continue;
                sum += (double)(value * value);
            }
            double rms = Math.sqrt(sum / (double)(length / stride));
            return (float)(rms / 128.0);
        }

        public float getAudioLevelLeft() {
            return this.audioLevelLeft;
        }

        public float getAudioLevelRight() {
            return this.audioLevelRight;
        }
    }

    protected static class MouseGrabber
    implements Runnable {
        private Point prevCapturedMouseLocation = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        private ScheduledThreadPoolExecutor timer;
        private ScreenRecorder recorder;
        private GraphicsDevice captureDevice;
        private Rectangle captureArea;
        private BlockingQueue<Buffer> mouseCaptures;
        private volatile long stopTime = Long.MAX_VALUE;
        private long startTime;
        private Format format;
        private ScheduledFuture<?> future;
        private volatile boolean mousePressed;
        private volatile boolean mouseWasPressed;
        private volatile boolean mousePressedRecorded;
        private Rectangle cursorImageArea;
        private Point cursorOffset;

        public MouseGrabber(ScreenRecorder recorder, long startTime, ScheduledThreadPoolExecutor timer) {
            this.timer = timer;
            this.format = recorder.mouseFormat;
            this.captureDevice = recorder.captureDevice;
            this.captureArea = recorder.captureArea;
            this.mouseCaptures = recorder.mouseCaptures;
            this.startTime = startTime;
            this.cursorImageArea = new Rectangle(0, 0, recorder.cursorImg.getWidth(), recorder.cursorImg.getHeight());
            this.cursorOffset = recorder.cursorOffset;
        }

        public void setFuture(ScheduledFuture<?> future) {
            this.future = future;
        }

        public void setMousePressed(boolean newValue) {
            if (newValue) {
                this.mouseWasPressed = true;
            }
            this.mousePressed = newValue;
        }

        @Override
        public void run() {
            try {
                this.grabMouse();
            }
            catch (Throwable ex) {
                this.timer.shutdown();
                this.recorder.recordingFailed(ex);
            }
        }

        public synchronized void setStopTime(long newValue) {
            this.stopTime = newValue;
        }

        public synchronized long getStopTime() {
            return this.stopTime;
        }

        private void grabMouse() throws InterruptedException {
            long now = System.currentTimeMillis();
            if (now > this.getStopTime()) {
                this.future.cancel(false);
                return;
            }
            PointerInfo info = MouseInfo.getPointerInfo();
            Point p = info.getLocation();
            this.cursorImageArea.x = p.x + this.cursorOffset.x;
            this.cursorImageArea.y = p.y + this.cursorOffset.y;
            if (!info.getDevice().equals(this.captureDevice) || !this.captureArea.intersects(this.cursorImageArea)) {
                p.setLocation(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            if (!p.equals(this.prevCapturedMouseLocation) || this.mouseWasPressed != this.mousePressedRecorded) {
                Buffer buf = new Buffer();
                buf.format = this.format;
                buf.timeStamp = new Rational(now, 1000L);
                buf.data = p;
                buf.header = this.mouseWasPressed;
                this.mousePressedRecorded = this.mouseWasPressed;
                this.mouseCaptures.put(buf);
                this.prevCapturedMouseLocation.setLocation(p);
            }
            this.mouseWasPressed = this.mousePressed;
        }

        public void close() {
        }
    }

    private static class ScreenGrabber
    implements Runnable {
        private Point prevDrawnMouseLocation = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        private boolean prevMousePressed = false;
        private BufferedImage screenCapture;
        private ScreenRecorder recorder;
        private ScheduledThreadPoolExecutor screenTimer;
        private Robot robot;
        private Rectangle captureArea;
        private BufferedImage videoImg;
        private Graphics2D videoGraphics;
        private final Format mouseFormat;
        private ArrayBlockingQueue<Buffer> mouseCaptures;
        private Rational prevScreenCaptureTime;
        private final Object sync;
        private BufferedImage cursorImg;
        private BufferedImage cursorImgPressed;
        private Point cursorOffset;
        private int videoTrack;
        private long startTime;
        private volatile long stopTime = Long.MAX_VALUE;
        private ScheduledFuture<?> future;
        private long sequenceNumber;

        public void setFuture(ScheduledFuture<?> future) {
            this.future = future;
        }

        public synchronized void setStopTime(long newValue) {
            this.stopTime = newValue;
        }

        public synchronized long getStopTime() {
            return this.stopTime;
        }

        public ScreenGrabber(ScreenRecorder recorder, long startTime) throws AWTException, IOException {
            this.recorder = recorder;
            this.captureArea = recorder.captureArea;
            this.robot = new Robot(recorder.captureDevice);
            this.mouseFormat = recorder.mouseFormat;
            this.mouseCaptures = recorder.mouseCaptures;
            this.sync = recorder.sync;
            this.cursorImg = recorder.cursorImg;
            this.cursorImgPressed = recorder.cursorImgPressed;
            this.cursorOffset = recorder.cursorOffset;
            this.videoTrack = recorder.videoTrack;
            this.prevScreenCaptureTime = new Rational(startTime, 1000L);
            this.startTime = startTime;
            Format screenFormat = recorder.screenFormat;
            if (screenFormat.get(VideoFormatKeys.DepthKey, 24) == 24) {
                this.videoImg = new BufferedImage(this.captureArea.width, this.captureArea.height, 1);
            } else if (screenFormat.get(VideoFormatKeys.DepthKey) == 16) {
                this.videoImg = new BufferedImage(this.captureArea.width, this.captureArea.height, 9);
            } else if (screenFormat.get(VideoFormatKeys.DepthKey) == 8) {
                this.videoImg = new BufferedImage(this.captureArea.width, this.captureArea.height, 13, Colors.createMacColors());
            } else {
                throw new IOException("Unsupported color depth " + screenFormat.get(VideoFormatKeys.DepthKey));
            }
            this.videoGraphics = this.videoImg.createGraphics();
            this.videoGraphics.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            this.videoGraphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            this.videoGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        }

        @Override
        public void run() {
            try {
                this.grabScreen();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                this.screenTimer.shutdown();
                this.recorder.recordingFailed(ex);
            }
        }

        private void grabScreen() throws IOException, InterruptedException {
            BufferedImage previousScreenCapture = this.screenCapture;
            long timeBeforeCapture = System.currentTimeMillis();
            try {
                this.screenCapture = this.robot.createScreenCapture(this.captureArea);
            }
            catch (IllegalMonitorStateException e) {
                return;
            }
            long timeAfterCapture = System.currentTimeMillis();
            if (previousScreenCapture == null) {
                previousScreenCapture = this.screenCapture;
            }
            this.videoGraphics.drawImage((Image)previousScreenCapture, 0, 0, null);
            Buffer buf = new Buffer();
            buf.format = new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, "image"});
            boolean hasMouseCapture = false;
            if (this.mouseFormat != null && ((Rational)this.mouseFormat.get(VideoFormatKeys.FrameRateKey)).intValue() > 0) {
                while (!this.mouseCaptures.isEmpty() && this.mouseCaptures.peek().timeStamp.compareTo(new Rational(timeAfterCapture, 1000L)) < 0) {
                    Buffer mouseCapture = this.mouseCaptures.poll();
                    if (mouseCapture.timeStamp.compareTo(this.prevScreenCaptureTime) <= 0) continue;
                    if (mouseCapture.timeStamp.compareTo(new Rational(timeBeforeCapture, 1000L)) < 0) {
                        previousScreenCapture = this.screenCapture;
                        this.videoGraphics.drawImage((Image)previousScreenCapture, 0, 0, null);
                    }
                    Point mcp = (Point)mouseCapture.data;
                    this.prevMousePressed = (Boolean)mouseCapture.header;
                    this.prevDrawnMouseLocation.setLocation(mcp.x - this.captureArea.x, mcp.y - this.captureArea.y);
                    Point p = this.prevDrawnMouseLocation;
                    long localStopTime = this.getStopTime();
                    if (mouseCapture.timeStamp.compareTo(new Rational(localStopTime, 1000L)) > 0) break;
                    hasMouseCapture = true;
                    if (this.prevMousePressed) {
                        this.videoGraphics.drawImage((Image)this.cursorImgPressed, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, null);
                    } else {
                        this.videoGraphics.drawImage((Image)this.cursorImg, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, null);
                    }
                    buf.clearFlags();
                    buf.data = this.videoImg;
                    buf.sampleDuration = mouseCapture.timeStamp.subtract(this.prevScreenCaptureTime);
                    buf.timeStamp = this.prevScreenCaptureTime.subtract(new Rational(this.startTime, 1000L));
                    buf.track = this.videoTrack;
                    ++this.sequenceNumber;
                    buf.sequenceNumber = buf.sequenceNumber;
                    buf.header = p.x == Integer.MAX_VALUE ? null : p;
                    this.recorder.write(buf);
                    this.prevScreenCaptureTime = mouseCapture.timeStamp;
                    this.videoGraphics.drawImage(previousScreenCapture, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, p.x + this.cursorOffset.x + this.cursorImg.getWidth() - 1, p.y + this.cursorOffset.y + this.cursorImg.getHeight() - 1, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, p.x + this.cursorOffset.x + this.cursorImg.getWidth() - 1, p.y + this.cursorOffset.y + this.cursorImg.getHeight() - 1, null);
                }
                if (!hasMouseCapture && this.prevScreenCaptureTime.compareTo(new Rational(this.getStopTime(), 1000L)) < 0) {
                    Point p = this.prevDrawnMouseLocation;
                    if (p != null) {
                        if (this.prevMousePressed) {
                            this.videoGraphics.drawImage((Image)this.cursorImgPressed, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, null);
                        } else {
                            this.videoGraphics.drawImage((Image)this.cursorImg, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, null);
                        }
                    }
                    buf.data = this.videoImg;
                    buf.sampleDuration = new Rational(timeAfterCapture, 1000L).subtract(this.prevScreenCaptureTime);
                    buf.timeStamp = this.prevScreenCaptureTime.subtract(new Rational(this.startTime, 1000L));
                    buf.track = this.videoTrack;
                    buf.sequenceNumber = this.sequenceNumber++;
                    buf.header = p.x == Integer.MAX_VALUE ? null : p;
                    this.recorder.write(buf);
                    this.prevScreenCaptureTime = new Rational(timeAfterCapture, 1000L);
                    if (p != null) {
                        this.videoGraphics.drawImage(previousScreenCapture, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, p.x + this.cursorOffset.x + this.cursorImg.getWidth() - 1, p.y + this.cursorOffset.y + this.cursorImg.getHeight() - 1, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, p.x + this.cursorOffset.x + this.cursorImg.getWidth() - 1, p.y + this.cursorOffset.y + this.cursorImg.getHeight() - 1, null);
                    }
                }
            } else if (this.prevScreenCaptureTime.compareTo(new Rational(this.getStopTime(), 1000L)) < 0) {
                buf.data = this.videoImg;
                buf.sampleDuration = new Rational(timeAfterCapture, 1000L).subtract(this.prevScreenCaptureTime);
                buf.timeStamp = this.prevScreenCaptureTime.subtract(new Rational(this.startTime, 1000L));
                buf.track = this.videoTrack;
                buf.sequenceNumber = this.sequenceNumber++;
                buf.header = null;
                this.recorder.write(buf);
                this.prevScreenCaptureTime = new Rational(timeAfterCapture, 1000L);
            }
            if (timeBeforeCapture > this.getStopTime()) {
                this.future.cancel(false);
            }
        }

        public void close() {
            this.videoGraphics.dispose();
            this.videoImg.flush();
        }
    }

    public static enum State {
        DONE,
        FAILED,
        RECORDING,
        FAILING;

    }
}

