/*
 * Decompiled with CFR 0.152.
 */
package ru.siksmfp.kacopy.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.siksmfp.kacopy.api.IFastCloner;
import ru.siksmfp.kacopy.cloners.CopierInternalProperties;

public class CopierSettings {
    private CopierInternalProperties properties;

    private CopierSettings() {
        throw new IllegalStateException("Can't instanced copier settings");
    }

    CopierSettings(CopierInternalProperties properties) {
        this.properties = properties;
    }

    public void setNullTransient(boolean nullTransient) {
        this.properties.setNullTransient(nullTransient);
    }

    public boolean isNullTransient() {
        return this.properties.isNullTransient();
    }

    public void setCloneSynthetics(boolean cloneSynthetics) {
        this.properties.setCloneSynthetics(cloneSynthetics);
    }

    public boolean shallCloneSynthetics() {
        return this.properties.isCloneSynthetics();
    }

    public void cloneAnonymousParent(boolean cloneAnonymousParent) {
        this.properties.shouldCloneAnonymousParent(cloneAnonymousParent);
    }

    public boolean shallCloneAnonymousParent() {
        return this.properties.isCloneAnonymousParent();
    }

    public void doNotClone(Class<?> ... c) {
        this.properties.addIgnoredClasses(Arrays.asList(c));
    }

    public void doNotClone(List<Class<?>> classes) {
        this.properties.addIgnoredClasses(classes);
    }

    public void registerFastCloner(Class<?> c, IFastCloner fastCloner) {
        if (this.properties.getFastCloners().containsKey(c)) {
            throw new IllegalArgumentException(c + " already fast-cloned!");
        }
        this.properties.getFastCloners().put(c, fastCloner);
    }

    public void unregisterFastCloner(Class<?> c) {
        this.properties.getFastCloners().remove(c);
    }

    public Set<Class<?>> getIgnoredClasses() {
        return Collections.unmodifiableSet(this.properties.getIgnoredClasses());
    }

    public Map<Class<?>, IFastCloner> getFastCloners() {
        return Collections.unmodifiableMap(this.properties.getFastCloners());
    }
}

