/*
 * Decompiled with CFR 0.152.
 */
package ru.siksmfp.kacopy.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import ru.siksmfp.kacopy.api.CopierSettings;
import ru.siksmfp.kacopy.api.IDeepCloner;
import ru.siksmfp.kacopy.api.IFastCloner;
import ru.siksmfp.kacopy.api.Immutable;
import ru.siksmfp.kacopy.cloners.CopierInternalProperties;
import ru.siksmfp.kacopy.exception.CloningException;

public class KaCopier {
    private CopierInternalProperties properties;
    private IDeepCloner deepCloner = new IDeepCloner(){

        @Override
        public <T> T deepClone(T object, Map<Object, Object> clones) {
            try {
                return (T)KaCopier.this.cloneInternal(object, clones);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
    };
    public CopierSettings settings;

    public KaCopier() {
        this.properties = new CopierInternalProperties();
        this.settings = new CopierSettings(this.properties);
    }

    public <T> T deepCopy(T object) {
        if (object == null) {
            return null;
        }
        IdentityHashMap<Object, Object> clones = new IdentityHashMap<Object, Object>(32);
        try {
            return this.cloneInternal(object, clones);
        }
        catch (IllegalAccessException ex) {
            throw new CloningException("Error during cloning of " + object, ex);
        }
    }

    public <T> T shallowCopy(T object) {
        if (object == null) {
            return null;
        }
        try {
            return this.cloneInternal(object, null);
        }
        catch (IllegalAccessException ex) {
            throw new CloningException("Error during cloning of " + object, ex);
        }
    }

    private boolean isImmutable(Class<?> clz) {
        Boolean isIm = this.properties.getImmutableClassesCash().get(clz);
        if (isIm != null) {
            return isIm;
        }
        Class<Immutable> immutableAnnotation = Immutable.class;
        for (Annotation annotation : clz.getDeclaredAnnotations()) {
            if (annotation.annotationType() != immutableAnnotation) continue;
            this.properties.addImmutableClasseToCash(clz, Boolean.TRUE);
            return true;
        }
        for (Class<?> c = clz.getSuperclass(); c != null && c != Object.class; c = c.getSuperclass()) {
            for (Annotation annotation : c.getDeclaredAnnotations()) {
                Immutable im;
                if (annotation.annotationType() != Immutable.class || !(im = (Immutable)annotation).subClass()) continue;
                this.properties.getImmutableClassesCash().put(clz, Boolean.TRUE);
                return true;
            }
        }
        this.properties.addImmutableClasseToCash(clz, Boolean.FALSE);
        return false;
    }

    private <T> T cloneInternal(T object, Map<Object, Object> clonedFields) throws IllegalAccessException {
        Object clonedPreviously;
        if (object == null || object == this) {
            return null;
        }
        if (object instanceof Enum) {
            return object;
        }
        Class<?> clz = object.getClass();
        if (this.properties.getIgnoredClasses().contains(clz) || this.isImmutable(clz)) {
            return object;
        }
        Object object2 = clonedPreviously = clonedFields != null ? clonedFields.get(object) : null;
        if (clonedPreviously != null) {
            return (T)clonedPreviously;
        }
        Object fastClonedObject = this.fastClone(object, clonedFields);
        if (fastClonedObject != null) {
            if (clonedFields != null) {
                clonedFields.put(object, fastClonedObject);
            }
            return (T)fastClonedObject;
        }
        if (clz.isArray()) {
            return this.cloneArray(object, clonedFields);
        }
        return this.cloneObject(object, clonedFields, clz);
    }

    private <T> T cloneObject(T object, Map<Object, Object> clonedFields, Class<T> clz) throws IllegalAccessException {
        T newInstance = this.properties.getInstanter().newInstance(clz);
        if (clonedFields != null) {
            clonedFields.put(object, newInstance);
        }
        List<Field> fields = this.getFieldsForClass(clz);
        for (Field field : fields) {
            boolean shouldClone;
            field.setAccessible(true);
            int modifier = field.getModifiers();
            if (Modifier.isStatic(modifier) || this.properties.isNullTransient() && Modifier.isTransient(modifier)) continue;
            Object fieldObject = field.get(object);
            boolean bl = shouldClone = !(!this.properties.isCloneSynthetics() && field.isSynthetic() || !this.properties.isCloneAnonymousParent() && this.isAnonymousParent(field));
            Object fieldObjectClone = clonedFields != null ? (shouldClone ? this.cloneInternal(fieldObject, clonedFields) : fieldObject) : fieldObject;
            field.set(newInstance, fieldObjectClone);
        }
        return newInstance;
    }

    private <T> T cloneArray(T object, Map<Object, Object> clones) throws IllegalAccessException {
        Class<?> clz = object.getClass();
        int length = Array.getLength(object);
        Object newArray = Array.newInstance(clz.getComponentType(), length);
        if (clones != null) {
            clones.put(object, newArray);
        }
        if (clz.getComponentType().isPrimitive() || this.isImmutable(clz.getComponentType())) {
            System.arraycopy(object, 0, newArray, 0, length);
        } else {
            for (int i = 0; i < length; ++i) {
                Object v = Array.get(object, i);
                Object clone = clones != null ? this.cloneInternal(v, clones) : v;
                Array.set(newArray, i, clone);
            }
        }
        return (T)newArray;
    }

    private boolean isAnonymousParent(Field field) {
        return "this$0".equals(field.getName());
    }

    private List<Field> getFieldsForClass(Class<?> clazz) {
        List<Field> fieldsForClass = this.properties.getFieldsCache().get(clazz);
        if (fieldsForClass == null) {
            fieldsForClass = new ArrayList<Field>();
            Field[] fields = clazz.getDeclaredFields();
            Collections.addAll(fieldsForClass, fields);
            Class<?> superClass = clazz;
            while ((superClass = superClass.getSuperclass()) != Object.class && superClass != null) {
                Collections.addAll(fieldsForClass, superClass.getDeclaredFields());
            }
            this.properties.getFieldsCache().putIfAbsent(clazz, fieldsForClass);
        }
        return fieldsForClass;
    }

    private Object fastClone(Object o, Map<Object, Object> clones) throws IllegalAccessException {
        Class<?> c = o.getClass();
        IFastCloner fastCloner = this.properties.getFastCloners().get(c);
        if (fastCloner != null) {
            return fastCloner.clone(o, this.deepCloner, clones);
        }
        return null;
    }
}

