/*
 * Decompiled with CFR 0.152.
 */
package ru.siksmfp.kacopy.cloners;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import ru.siksmfp.kacopy.api.IFastCloner;
import ru.siksmfp.kacopy.cloners.FastClonerArrayList;
import ru.siksmfp.kacopy.cloners.FastClonerCalendar;
import ru.siksmfp.kacopy.cloners.FastClonerConcurrentHashMap;
import ru.siksmfp.kacopy.cloners.FastClonerHashMap;
import ru.siksmfp.kacopy.cloners.FastClonerHashSet;
import ru.siksmfp.kacopy.cloners.FastClonerLinkedHashMap;
import ru.siksmfp.kacopy.cloners.FastClonerLinkedList;
import ru.siksmfp.kacopy.cloners.FastClonerTreeMap;
import ru.siksmfp.kacopy.instanter.api.Instanter;
import ru.siksmfp.kacopy.instanter.types.InstanterStd;

public class CopierInternalProperties {
    private Instanter instanter = new InstanterStd();
    private Set<Class<?>> ignoredClasses = new HashSet();
    private Map<Class<?>, IFastCloner> fastCloners = new HashMap();
    private ConcurrentHashMap<Class<?>, List<Field>> fieldsCache = new ConcurrentHashMap();
    private ConcurrentHashMap<Class<?>, Boolean> immutableClassesCash = new ConcurrentHashMap();
    private boolean cloneAnonymousParent = true;
    private boolean isNullTransient = false;
    private boolean isCloneSynthetics = true;

    public CopierInternalProperties() {
        this.ignoredClasses.addAll(Arrays.asList(String.class, Integer.class, Boolean.class, Class.class, Float.class, Double.class, Character.class, Byte.class, Short.class, Void.class, BigDecimal.class, BigInteger.class, URI.class, URL.class, UUID.class, Pattern.class));
        this.fastCloners.put(GregorianCalendar.class, new FastClonerCalendar());
        this.fastCloners.put(ArrayList.class, new FastClonerArrayList());
        this.fastCloners.put(LinkedList.class, new FastClonerLinkedList());
        this.fastCloners.put(HashSet.class, new FastClonerHashSet());
        this.fastCloners.put(HashMap.class, new FastClonerHashMap());
        this.fastCloners.put(TreeMap.class, new FastClonerTreeMap());
        this.fastCloners.put(LinkedHashMap.class, new FastClonerLinkedHashMap());
        this.fastCloners.put(ConcurrentHashMap.class, new FastClonerConcurrentHashMap());
    }

    public Instanter getInstanter() {
        return this.instanter;
    }

    public Set<Class<?>> getIgnoredClasses() {
        return this.ignoredClasses;
    }

    public void addIgnoredClasses(List<Class<?>> classes) {
        this.ignoredClasses.addAll(classes);
    }

    public Map<Class<?>, IFastCloner> getFastCloners() {
        return this.fastCloners;
    }

    public void setFastCloners(Map<Class<?>, IFastCloner> fastCloners) {
        this.fastCloners = fastCloners;
    }

    public ConcurrentHashMap<Class<?>, List<Field>> getFieldsCache() {
        return this.fieldsCache;
    }

    public void setFieldsCache(ConcurrentHashMap<Class<?>, List<Field>> fieldsCache) {
        this.fieldsCache = fieldsCache;
    }

    public ConcurrentHashMap<Class<?>, Boolean> getImmutableClassesCash() {
        return this.immutableClassesCash;
    }

    public void addImmutableClasseToCash(Class<?> clazz, boolean isImmutable) {
        this.immutableClassesCash.put(clazz, isImmutable);
    }

    public boolean isCloneAnonymousParent() {
        return this.cloneAnonymousParent;
    }

    public void shouldCloneAnonymousParent(boolean cloneAnonymousParent) {
        this.cloneAnonymousParent = cloneAnonymousParent;
    }

    public boolean isNullTransient() {
        return this.isNullTransient;
    }

    public void setNullTransient(boolean nullTransient) {
        this.isNullTransient = nullTransient;
    }

    public boolean isCloneSynthetics() {
        return this.isCloneSynthetics;
    }

    public void setCloneSynthetics(boolean cloneSynthetics) {
        this.isCloneSynthetics = cloneSynthetics;
    }
}

