/*
 * Decompiled with CFR 0.152.
 */
package ru.siksmfp.kacopy.instanter.perc;

import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import ru.siksmfp.kacopy.exception.InstanterException;
import ru.siksmfp.kacopy.instanter.annotations.Instantiator;
import ru.siksmfp.kacopy.instanter.annotations.Typology;
import ru.siksmfp.kacopy.instanter.api.ObjectInstantiator;

@Instantiator(value=Typology.STANDARD)
public class PercInstantiator<T>
implements ObjectInstantiator<T> {
    private final Method newInstanceMethod;
    private final Object[] typeArgs = new Object[]{null, Boolean.FALSE};

    public PercInstantiator(Class<T> type) {
        this.typeArgs[0] = type;
        try {
            this.newInstanceMethod = ObjectInputStream.class.getDeclaredMethod("newInstance", Class.class, Boolean.TYPE);
            this.newInstanceMethod.setAccessible(true);
        }
        catch (RuntimeException e) {
            throw new InstanterException(e);
        }
        catch (NoSuchMethodException e) {
            throw new InstanterException(e);
        }
    }

    @Override
    public T newInstance() {
        try {
            return (T)this.newInstanceMethod.invoke(null, this.typeArgs);
        }
        catch (Exception e) {
            throw new InstanterException(e);
        }
    }
}

