/*
 * Decompiled with CFR 0.152.
 */
package ru.siksmfp.kacopy.instanter.strategy;

import java.io.Serializable;
import ru.siksmfp.kacopy.instanter.android.Android10Instantiator;
import ru.siksmfp.kacopy.instanter.android.Android17Instantiator;
import ru.siksmfp.kacopy.instanter.android.Android18Instantiator;
import ru.siksmfp.kacopy.instanter.api.ObjectInstantiator;
import ru.siksmfp.kacopy.instanter.basic.AccessibleInstantiator;
import ru.siksmfp.kacopy.instanter.basic.ObjectInputStreamInstantiator;
import ru.siksmfp.kacopy.instanter.gcj.GCJInstantiator;
import ru.siksmfp.kacopy.instanter.perc.PercInstantiator;
import ru.siksmfp.kacopy.instanter.strategy.BaseInstantiatorStrategy;
import ru.siksmfp.kacopy.instanter.strategy.PlatformDescription;
import ru.siksmfp.kacopy.instanter.sun.SunReflectionFactoryInstantiator;
import ru.siksmfp.kacopy.instanter.sun.UnsafeFactoryInstantiator;

public class StdInstantiatorStrategy
extends BaseInstantiatorStrategy {
    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type) {
        if (PlatformDescription.isThisJVM("Java HotSpot") || PlatformDescription.isThisJVM("OpenJDK")) {
            if (PlatformDescription.isGoogleAppEngine() && PlatformDescription.SPECIFICATION_VERSION.equals("1.7")) {
                if (Serializable.class.isAssignableFrom(type)) {
                    return new ObjectInputStreamInstantiator<T>(type);
                }
                return new AccessibleInstantiator<T>(type);
            }
            return new SunReflectionFactoryInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("Dalvik")) {
            if (PlatformDescription.isAndroidOpenJDK()) {
                return new UnsafeFactoryInstantiator<T>(type);
            }
            if (PlatformDescription.ANDROID_VERSION <= 10) {
                return new Android10Instantiator<T>(type);
            }
            if (PlatformDescription.ANDROID_VERSION <= 17) {
                return new Android17Instantiator<T>(type);
            }
            return new Android18Instantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("BEA")) {
            return new SunReflectionFactoryInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("GNU libgcj")) {
            return new GCJInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("PERC")) {
            return new PercInstantiator<T>(type);
        }
        return new UnsafeFactoryInstantiator<T>(type);
    }
}

