/*
 * Decompiled with CFR 0.152.
 */
package ru.sms_activate;

import com.google.gson.reflect.TypeToken;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.sms_activate.SMSActivateAction;
import ru.sms_activate.SMSActivateErrorResponse;
import ru.sms_activate.SMSActivateGetRentNumberResponse;
import ru.sms_activate.SMSActivateJsonParser;
import ru.sms_activate.SMSActivateURLBuilder;
import ru.sms_activate.SMSActivateURLKey;
import ru.sms_activate.SMSActivateValidator;
import ru.sms_activate.SMSActivateWebClient;
import ru.sms_activate.client_enums.SMSActivateClientRentStatus;
import ru.sms_activate.client_enums.SMSActivateClientStatus;
import ru.sms_activate.error.base.SMSActivateBaseException;
import ru.sms_activate.error.base.SMSActivateBaseTypeError;
import ru.sms_activate.error.wrong_parameter.SMSActivateWrongParameter;
import ru.sms_activate.error.wrong_parameter.SMSActivateWrongParameterException;
import ru.sms_activate.listener.SMSActivateExceptionListener;
import ru.sms_activate.listener.SMSActivateWebClientListener;
import ru.sms_activate.response.api_activation.SMSActivateActivation;
import ru.sms_activate.response.api_activation.SMSActivateGetBalanceAndCashBackResponse;
import ru.sms_activate.response.api_activation.SMSActivateGetCountriesResponse;
import ru.sms_activate.response.api_activation.SMSActivateGetFullSmsResponse;
import ru.sms_activate.response.api_activation.SMSActivateGetMultiServiceNumberResponse;
import ru.sms_activate.response.api_activation.SMSActivateGetNumbersStatusResponse;
import ru.sms_activate.response.api_activation.SMSActivateGetPricesResponse;
import ru.sms_activate.response.api_activation.SMSActivateGetStatusResponse;
import ru.sms_activate.response.api_activation.SMSActivateSetStatusResponse;
import ru.sms_activate.response.api_activation.enums.SMSActivateGetStatusActivation;
import ru.sms_activate.response.api_activation.enums.SMSActivateServerStatus;
import ru.sms_activate.response.api_activation.enums.SMSActivateStatusNumber;
import ru.sms_activate.response.api_activation.extra.SMSActivateCountryInfo;
import ru.sms_activate.response.api_activation.extra.SMSActivateGetPriceInfo;
import ru.sms_activate.response.api_activation.extra.SMSActivateServiceInfo;
import ru.sms_activate.response.api_rent.SMSActivateGetRentListResponse;
import ru.sms_activate.response.api_rent.SMSActivateGetRentServicesAndCountriesResponse;
import ru.sms_activate.response.api_rent.SMSActivateGetRentStatusResponse;
import ru.sms_activate.response.api_rent.enums.SMSActivateRentStatus;
import ru.sms_activate.response.api_rent.extra.SMSActivateRentActivation;
import ru.sms_activate.response.api_rent.extra.SMSActivateSMS;
import ru.sms_activate.response.qiwi.SMSActivateGetQiwiRequisitesResponse;

public class SMSActivateApi {
    public static final int MINIMAL_RENT_TIME = 4;
    private static final Pattern patternDigit = Pattern.compile("\\d+(?:[\\.,]\\d+)?");
    private final SMSActivateValidator validator = new SMSActivateValidator();
    private final String apiKey;
    private String ref = null;
    private SMSActivateWebClientListener smsActivateWebClientListener;

    public SMSActivateApi(@NotNull String apiKey) throws SMSActivateWrongParameterException {
        if (apiKey.isEmpty()) {
            throw new SMSActivateWrongParameterException(SMSActivateWrongParameter.EMPTY_KEY);
        }
        this.apiKey = apiKey;
    }

    public void setSmsActivateWebClientListener(@NotNull SMSActivateWebClientListener smsActivateWebClientListener) {
        this.smsActivateWebClientListener = smsActivateWebClientListener;
    }

    public void setSmsActivateExceptionListener(@NotNull SMSActivateExceptionListener smsActivateExceptionListener) {
        this.validator.setSmsActivateExceptionListener(smsActivateExceptionListener);
    }

    @NotNull
    public String getApiKey() {
        return this.apiKey;
    }

    public void setRef(@NotNull String ref) {
        this.ref = ref;
    }

    @Nullable
    public String getRef() {
        return this.ref;
    }

    @NotNull
    public BigDecimal getBalance() throws SMSActivateBaseException {
        return this.getBalanceByAction(SMSActivateAction.GET_BALANCE);
    }

    @NotNull
    public SMSActivateGetBalanceAndCashBackResponse getBalanceAndCashBack() throws SMSActivateBaseException {
        BigDecimal balance = this.getBalance();
        BigDecimal balanceAndCashBack = this.getBalanceByAction(SMSActivateAction.GET_BALANCE_AND_CASHBACK);
        return new SMSActivateGetBalanceAndCashBackResponse(balance, balanceAndCashBack.subtract(balance));
    }

    @NotNull
    public SMSActivateGetNumbersStatusResponse getNumbersStatusByDefaultSettingFromSite() throws SMSActivateBaseException {
        return this.getNumbersStatus(null, null);
    }

    @NotNull
    public SMSActivateGetNumbersStatusResponse getNumbersStatus(@Nullable Integer countryId, @Nullable Set<String> operatorSet) throws SMSActivateBaseException {
        if (countryId != null && countryId < 0) {
            throw new SMSActivateWrongParameterException(SMSActivateWrongParameter.WRONG_COUNTRY_ID);
        }
        String operator = null;
        if (operatorSet != null) {
            operatorSet.removeIf(String::isEmpty);
            if (!operatorSet.isEmpty()) {
                operator = String.join((CharSequence)",", operatorSet);
            }
        }
        SMSActivateURLBuilder smsActivateURLBuilder = new SMSActivateURLBuilder(this.apiKey, SMSActivateAction.GET_NUMBERS_STATUS);
        smsActivateURLBuilder.append(SMSActivateURLKey.OPERATOR, operator);
        if (countryId != null) {
            smsActivateURLBuilder.append(SMSActivateURLKey.COUNTRY, String.valueOf(countryId));
        }
        String serviceJsonResponse = new SMSActivateWebClient(this.smsActivateWebClientListener).getOrThrowCommonException(smsActivateURLBuilder, this.validator);
        SMSActivateJsonParser jsonParser = new SMSActivateJsonParser();
        Map serviceMap = (Map)jsonParser.tryParseJson(serviceJsonResponse, new TypeToken<Map<String, Integer>>(){}.getType(), this.validator);
        HashMap<String, SMSActivateServiceInfo> serviceInfoMap = new HashMap<String, SMSActivateServiceInfo>();
        for (Map.Entry entry : serviceMap.entrySet()) {
            String serviceName = (String)entry.getKey();
            String[] parts = serviceName.split("_");
            serviceInfoMap.put(serviceName, new SMSActivateServiceInfo(parts[0], (Integer)entry.getValue(), parts[1].equals("1")));
        }
        return new SMSActivateGetNumbersStatusResponse(serviceInfoMap);
    }

    @NotNull
    public SMSActivateActivation getNumber(int countryId, @NotNull String service) throws SMSActivateBaseException {
        return this.getNumber(countryId, service, false);
    }

    @NotNull
    public SMSActivateActivation getNumber(int countryId, @NotNull String service, boolean forward) throws SMSActivateBaseException {
        return this.getNumber(countryId, service, forward, null, null);
    }

    @NotNull
    public SMSActivateActivation getNumber(int countryId, @NotNull String service, boolean forward, @Nullable Set<String> operatorSet, @Nullable Set<String> phoneExceptionSet) throws SMSActivateBaseException {
        if (countryId < 0) {
            throw new SMSActivateWrongParameterException(SMSActivateWrongParameter.WRONG_COUNTRY_ID);
        }
        String phoneException = null;
        String operator = null;
        if (phoneExceptionSet != null) {
            phoneExceptionSet.removeIf(String::isEmpty);
            if (!phoneExceptionSet.isEmpty()) {
                phoneException = String.join((CharSequence)",", phoneExceptionSet);
            }
        }
        if (operatorSet != null) {
            operatorSet.removeIf(String::isEmpty);
            if (!operatorSet.isEmpty()) {
                operator = String.join((CharSequence)",", operatorSet);
            }
        }
        SMSActivateURLBuilder smsActivateURLBuilder = new SMSActivateURLBuilder(this.apiKey, SMSActivateAction.GET_NUMBER);
        smsActivateURLBuilder.append(SMSActivateURLKey.REF, this.ref).append(SMSActivateURLKey.COUNTRY, String.valueOf(countryId)).append(SMSActivateURLKey.SERVICE, service).append(SMSActivateURLKey.FORWARD, forward ? "1" : "0").append(SMSActivateURLKey.OPERATOR, operator).append(SMSActivateURLKey.PHONE_EXCEPTION, phoneException);
        String responseFromServer = new SMSActivateWebClient(this.smsActivateWebClientListener).getOrThrowCommonException(smsActivateURLBuilder, this.validator);
        this.validator.throwExceptionWithBan(responseFromServer);
        if (!responseFromServer.startsWith("ACCESS")) {
            throw this.validator.getBaseExceptionByErrorNameOrUnknown(responseFromServer, null);
        }
        try {
            String[] parts = responseFromServer.split(":");
            int id = Integer.parseInt(parts[1]);
            long number = Long.parseLong(parts[2]);
            return new SMSActivateActivation(id, number, service);
        }
        catch (NumberFormatException e) {
            throw this.validator.getBaseExceptionByErrorNameOrUnknown(responseFromServer, "Error formatting to number.");
        }
    }

    @NotNull
    public SMSActivateGetMultiServiceNumberResponse getMultiServiceNumber(int countryId, @NotNull Set<String> multiServiceSet) throws SMSActivateBaseException {
        return this.getMultiServiceNumber(countryId, multiServiceSet, null, null);
    }

    @NotNull
    public SMSActivateGetMultiServiceNumberResponse getMultiServiceNumber(int countryId, @NotNull Map<String, Boolean> serviceMap) throws SMSActivateBaseException {
        return this.getMultiServiceNumber(countryId, serviceMap, null);
    }

    @NotNull
    public SMSActivateGetMultiServiceNumberResponse getMultiServiceNumber(int countryId, @NotNull Map<String, Boolean> serviceMap, @Nullable Set<String> operatorSet) throws SMSActivateBaseException {
        return this.getMultiServiceNumber(countryId, serviceMap.keySet(), operatorSet, new ArrayList<Boolean>(serviceMap.values()));
    }

    @NotNull
    private SMSActivateGetMultiServiceNumberResponse getMultiServiceNumber(int countryId, @NotNull Set<String> multiServiceSet, @Nullable Set<String> operatorSet, @Nullable List<Boolean> multiForwardList) throws SMSActivateBaseException {
        if (countryId < 0) {
            throw new SMSActivateWrongParameterException(SMSActivateWrongParameter.WRONG_COUNTRY_ID);
        }
        multiServiceSet.removeIf(String::isEmpty);
        String strMultiService = String.join((CharSequence)",", multiServiceSet);
        String strOperators = null;
        String strMultiForward = null;
        if (multiForwardList != null) {
            strMultiForward = multiForwardList.stream().filter(forward -> !Objects.isNull(forward)).map(forward -> forward != false ? "1" : "0").collect(Collectors.joining(","));
        }
        if (operatorSet != null) {
            operatorSet.removeIf(String::isEmpty);
            strOperators = String.join((CharSequence)",", operatorSet);
        }
        SMSActivateURLBuilder smsActivateURLBuilder = new SMSActivateURLBuilder(this.apiKey, SMSActivateAction.GET_MULTI_SERVICE_NUMBER);
        smsActivateURLBuilder.append(SMSActivateURLKey.REF, String.valueOf(this.ref)).append(SMSActivateURLKey.MULTI_SERVICE, strMultiService).append(SMSActivateURLKey.COUNTRY, String.valueOf(countryId)).append(SMSActivateURLKey.MULTI_FORWARD, strMultiForward).append(SMSActivateURLKey.OPERATOR, strOperators);
        String jsonFromServer = new SMSActivateWebClient(this.smsActivateWebClientListener).getOrThrowCommonException(smsActivateURLBuilder, this.validator);
        SMSActivateJsonParser jsonParser = new SMSActivateJsonParser();
        this.validator.throwExceptionWithBan(jsonFromServer);
        List smsActivateActivationList = (List)jsonParser.tryParseJson(jsonFromServer, new TypeToken<List<SMSActivateActivation>>(){}.getType(), this.validator);
        return new SMSActivateGetMultiServiceNumberResponse(smsActivateActivationList);
    }

    @NotNull
    public SMSActivateSetStatusResponse setStatus(int activationId, @NotNull SMSActivateClientStatus status) throws SMSActivateBaseException {
        return this.setStatusWithForwardPhone(activationId, status, null);
    }

    @NotNull
    public SMSActivateSetStatusResponse setStatus(@NotNull SMSActivateActivation activation, @NotNull SMSActivateClientStatus status) throws SMSActivateBaseException {
        return this.setStatus(activation.getId(), status);
    }

    @NotNull
    public SMSActivateSetStatusResponse setStatusWithForwardPhone(int activationId, @NotNull SMSActivateClientStatus status, @Nullable Long forwardPhone) throws SMSActivateBaseException {
        String statusFromServer;
        SMSActivateServerStatus smsActivateServerStatus;
        if (forwardPhone != null && forwardPhone <= 0L) {
            throw new SMSActivateWrongParameterException("Phone number for forwarding must be positive.", "\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0430\u0434\u0440\u0435\u0441\u0430\u0446\u0438\u0438 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439.");
        }
        SMSActivateURLBuilder smsActivateURLBuilder = new SMSActivateURLBuilder(this.apiKey, SMSActivateAction.SET_STATUS);
        smsActivateURLBuilder.append(SMSActivateURLKey.STATUS, String.valueOf(status.getId())).append(SMSActivateURLKey.ID, String.valueOf(activationId));
        if (forwardPhone != null) {
            smsActivateURLBuilder.append(SMSActivateURLKey.FORWARD, String.valueOf(forwardPhone));
        }
        if ((smsActivateServerStatus = SMSActivateServerStatus.getStatusByName(statusFromServer = new SMSActivateWebClient(this.smsActivateWebClientListener).getOrThrowCommonException(smsActivateURLBuilder, this.validator))) != SMSActivateServerStatus.UNKNOWN) {
            return new SMSActivateSetStatusResponse(smsActivateServerStatus);
        }
        throw this.validator.getBaseExceptionByErrorNameOrUnknown(statusFromServer, null);
    }

    @NotNull
    public SMSActivateGetStatusResponse getStatus(int activationId) throws SMSActivateBaseException {
        SMSActivateGetStatusActivation status;
        SMSActivateURLBuilder smsActivateURLBuilder = new SMSActivateURLBuilder(this.apiKey, SMSActivateAction.GET_STATUS);
        smsActivateURLBuilder.append(SMSActivateURLKey.ID, String.valueOf(activationId));
        String code = null;
        String statusFromServer = new SMSActivateWebClient(this.smsActivateWebClientListener).getOrThrowCommonException(smsActivateURLBuilder, this.validator);
        if (statusFromServer.contains(":")) {
            String[] parts = statusFromServer.split(":");
            statusFromServer = parts[0];
            code = parts[1];
        }
        if ((status = SMSActivateGetStatusActivation.getStatusByName(statusFromServer)) != SMSActivateGetStatusActivation.UNKNOWN) {
            return new SMSActivateGetStatusResponse(status, code);
        }
        throw this.validator.getBaseExceptionByErrorNameOrUnknown(statusFromServer, null);
    }

    @NotNull
    public SMSActivateGetStatusResponse getStatus(@NotNull SMSActivateActivation activation) throws SMSActivateBaseException {
        return this.getStatus(activation.getId());
    }

    @NotNull
    public SMSActivateGetFullSmsResponse getFullSms(int activationId) throws SMSActivateBaseException {
        SMSActivateURLBuilder smsActivateURLBuilder = new SMSActivateURLBuilder(this.apiKey, SMSActivateAction.GET_FULL_SMS);
        smsActivateURLBuilder.append(SMSActivateURLKey.ID, String.valueOf(activationId));
        String smsFromServer = new SMSActivateWebClient(this.smsActivateWebClientListener).getOrThrowCommonException(smsActivateURLBuilder, this.validator);
        SMSActivateStatusNumber smsActivateStatusNumber = SMSActivateStatusNumber.getStatusByName(smsFromServer);
        if (smsActivateStatusNumber != SMSActivateStatusNumber.UNKNOWN) {
            String message = "";
            if (smsActivateStatusNumber == SMSActivateStatusNumber.FULL_SMS) {
                message = smsFromServer.split(":", 2)[1];
            }
            return new SMSActivateGetFullSmsResponse(smsActivateStatusNumber, message);
        }
        throw this.validator.getBaseExceptionByErrorNameOrUnknown(smsFromServer, null);
    }

    @NotNull
    public SMSActivateGetFullSmsResponse getFullSms(@NotNull SMSActivateActivation activation) throws SMSActivateBaseException {
        return this.getFullSms(activation.getId());
    }

    @NotNull
    public SMSActivateGetPricesResponse getAllPrices() throws SMSActivateBaseException {
        return this.getPricesByCountryIdAndServiceShortName(null, null);
    }

    @NotNull
    public SMSActivateGetPricesResponse getPricesAllServicesByCountryId(int countryId) throws SMSActivateBaseException {
        return this.getPricesByCountryIdAndServiceShortName(countryId, null);
    }

    @NotNull
    public SMSActivateGetPricesResponse getPricesAllCountryByServiceShortName(@NotNull String serviceShortName) throws SMSActivateBaseException {
        return this.getPricesByCountryIdAndServiceShortName(null, serviceShortName);
    }

    @NotNull
    public SMSActivateGetPricesResponse getPricesByCountryIdAndServiceShortName(@Nullable Integer countryId, @Nullable String serviceShortName) throws SMSActivateBaseException {
        SMSActivateURLBuilder smsActivateURLBuilder = new SMSActivateURLBuilder(this.apiKey, SMSActivateAction.GET_PRICES);
        if (serviceShortName != null) {
            if (serviceShortName.length() != 2) {
                throw new SMSActivateWrongParameterException("Wrong service short name.", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u043a\u043e\u0440\u043e\u0442\u043a\u043e\u0435 \u0438\u043c\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u0430.");
            }
            smsActivateURLBuilder.append(SMSActivateURLKey.SERVICE, serviceShortName);
        }
        if (countryId != null) {
            if (countryId < 0) {
                throw new SMSActivateWrongParameterException(SMSActivateWrongParameter.WRONG_COUNTRY_ID);
            }
            smsActivateURLBuilder.append(SMSActivateURLKey.COUNTRY, String.valueOf(countryId));
        }
        String jsonFromServer = new SMSActivateWebClient(this.smsActivateWebClientListener).getOrThrowCommonException(smsActivateURLBuilder, this.validator);
        SMSActivateJsonParser jsonParser = new SMSActivateJsonParser();
        Map smsActivateGetPriceMap = (Map)jsonParser.tryParseJson(jsonFromServer, new TypeToken<Map<Integer, Map<String, SMSActivateGetPriceInfo>>>(){}.getType(), this.validator);
        return new SMSActivateGetPricesResponse(smsActivateGetPriceMap);
    }

    @NotNull
    public SMSActivateGetCountriesResponse getCountries() throws SMSActivateBaseException {
        SMSActivateURLBuilder smsActivateURLBuilder = new SMSActivateURLBuilder(this.apiKey, SMSActivateAction.GET_COUNTRIES);
        String jsonFromServer = new SMSActivateWebClient(this.smsActivateWebClientListener).getOrThrowCommonException(smsActivateURLBuilder, this.validator);
        SMSActivateJsonParser jsonParser = new SMSActivateJsonParser();
        Map countryInformationMap = (Map)jsonParser.tryParseJson(jsonFromServer, new TypeToken<Map<Integer, SMSActivateCountryInfo>>(){}.getType(), this.validator);
        return new SMSActivateGetCountriesResponse(countryInformationMap);
    }

    @NotNull
    public SMSActivateGetQiwiRequisitesResponse getQiwiRequisites() throws SMSActivateBaseException {
        SMSActivateURLBuilder smsActivateURLBuilder = new SMSActivateURLBuilder(this.apiKey, SMSActivateAction.GET_QIWI_REQUISITES);
        String jsonFromServer = new SMSActivateWebClient(this.smsActivateWebClientListener).getOrThrowCommonException(smsActivateURLBuilder, this.validator);
        SMSActivateJsonParser jsonParser = new SMSActivateJsonParser();
        return (SMSActivateGetQiwiRequisitesResponse)jsonParser.tryParseJson(jsonFromServer, new TypeToken<SMSActivateGetQiwiRequisitesResponse>(){}.getType(), this.validator);
    }

    @NotNull
    public SMSActivateActivation getAdditionalService(@NotNull SMSActivateActivation parentActivation, @NotNull String service) throws SMSActivateBaseException {
        return this.getAdditionalService(parentActivation.getId(), service);
    }

    @NotNull
    public SMSActivateActivation getAdditionalService(int parentActivationId, @NotNull String service) throws SMSActivateBaseException {
        SMSActivateURLBuilder smsActivateURLBuilder = new SMSActivateURLBuilder(this.apiKey, SMSActivateAction.GET_ADDITIONAL_SERVICE);
        smsActivateURLBuilder.append(SMSActivateURLKey.ID, String.valueOf(parentActivationId)).append(SMSActivateURLKey.SERVICE, service);
        String responseFromServer = new SMSActivateWebClient(this.smsActivateWebClientListener).getOrThrowCommonException(smsActivateURLBuilder, this.validator);
        if (!responseFromServer.startsWith("ADDITIONAL")) {
            throw this.validator.getBaseExceptionByErrorNameOrUnknown(responseFromServer, null);
        }
        try {
            String[] parts = responseFromServer.split(":");
            int childId = Integer.parseInt(parts[1]);
            long number = Long.parseLong(parts[2]);
            return new SMSActivateActivation(childId, number, service);
        }
        catch (NumberFormatException e) {
            throw this.validator.getBaseExceptionByErrorNameOrUnknown(responseFromServer, "Error formatting to number.");
        }
    }

    @NotNull
    public SMSActivateGetRentServicesAndCountriesResponse getRentServicesAndCountries(int countryId, @Nullable Set<String> operatorSet, int hours) throws SMSActivateBaseException {
        if (hours < 4) {
            throw new SMSActivateWrongParameterException("Time rent can't be negative or equals 4", "\u0412\u0440\u0435\u043c\u044f \u0430\u0440\u0435\u043d\u0434\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e 4");
        }
        if (countryId < 0) {
            throw new SMSActivateWrongParameterException(SMSActivateWrongParameter.WRONG_COUNTRY_ID);
        }
        String operator = null;
        if (operatorSet != null) {
            operatorSet.removeIf(String::isEmpty);
            if (!operatorSet.isEmpty()) {
                operator = String.join((CharSequence)",", operatorSet);
            }
        }
        SMSActivateURLBuilder smsActivateURLBuilder = new SMSActivateURLBuilder(this.apiKey, SMSActivateAction.GET_RENT_SERVICES_AND_COUNTRIES);
        smsActivateURLBuilder.append(SMSActivateURLKey.COUNTRY, String.valueOf(countryId)).append(SMSActivateURLKey.OPERATOR, operator).append(SMSActivateURLKey.RENT_TIME, String.valueOf(hours));
        String jsonFromServer = new SMSActivateWebClient(this.smsActivateWebClientListener).getOrThrowCommonException(smsActivateURLBuilder, this.validator);
        SMSActivateJsonParser jsonParser = new SMSActivateJsonParser();
        return (SMSActivateGetRentServicesAndCountriesResponse)jsonParser.tryParseJson(jsonFromServer, new TypeToken<SMSActivateGetRentServicesAndCountriesResponse>(){}.getType(), this.validator);
    }

    @NotNull
    public SMSActivateRentActivation getRentNumber(int countryId, @NotNull String service) throws SMSActivateBaseException {
        return this.getRentNumber(countryId, service, 4);
    }

    @NotNull
    public SMSActivateRentActivation getRentNumber(int countryId, @NotNull String service, int hours) throws SMSActivateBaseException {
        return this.getRentNumber(countryId, service, null, hours, null);
    }

    @NotNull
    public SMSActivateRentActivation getRentNumber(int countryId, @NotNull String service, @Nullable String operator, int hours, @Nullable String urlWebhook) throws SMSActivateBaseException {
        if (countryId < 0) {
            throw new SMSActivateWrongParameterException(SMSActivateWrongParameter.WRONG_COUNTRY_ID);
        }
        if (hours < 4) {
            throw new SMSActivateWrongParameterException(String.format("The rental time cannot be less than %d.", 4), String.format("\u0412\u0440\u0435\u043c\u044f \u0430\u0440\u0435\u043d\u0434\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0447\u0435\u043c %d.", 4));
        }
        if (operator != null && operator.isEmpty()) {
            throw new SMSActivateWrongParameterException(SMSActivateWrongParameter.WRONG_OPERATOR);
        }
        if (urlWebhook != null && urlWebhook.isEmpty()) {
            throw new SMSActivateWrongParameterException("Parameter url-webhook can't be empty.", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0435\u0440 url-webhook \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c.");
        }
        SMSActivateURLBuilder smsActivateURLBuilder = new SMSActivateURLBuilder(this.apiKey, SMSActivateAction.GET_RENT_NUMBER);
        smsActivateURLBuilder.append(SMSActivateURLKey.RENT_TIME, String.valueOf(hours)).append(SMSActivateURLKey.COUNTRY, String.valueOf(countryId)).append(SMSActivateURLKey.OPERATOR, operator).append(SMSActivateURLKey.URL, urlWebhook).append(SMSActivateURLKey.SERVICE, service);
        String jsonFromServer = new SMSActivateWebClient(this.smsActivateWebClientListener).getOrThrowCommonException(smsActivateURLBuilder, this.validator);
        SMSActivateJsonParser jsonParser = new SMSActivateJsonParser();
        if (this.validator.containsSuccessStatus(jsonFromServer)) {
            SMSActivateErrorResponse errorResponse = (SMSActivateErrorResponse)jsonParser.tryParseJson(jsonFromServer, new TypeToken<SMSActivateErrorResponse>(){}.getType(), this.validator);
            throw this.validator.getBaseExceptionByErrorNameOrUnknown(errorResponse.getMessage(), null);
        }
        SMSActivateGetRentNumberResponse smsActivateGetRentNumberResponse = (SMSActivateGetRentNumberResponse)jsonParser.tryParseJson(jsonFromServer, new TypeToken<SMSActivateGetRentNumberResponse>(){}.getType(), this.validator);
        return smsActivateGetRentNumberResponse.getSMSmsActivateGetRentNumber();
    }

    @NotNull
    public SMSActivateGetRentStatusResponse getRentStatus(int rentId) throws SMSActivateBaseException {
        SMSActivateURLBuilder smsActivateURLBuilder = new SMSActivateURLBuilder(this.apiKey, SMSActivateAction.GET_RENT_STATUS);
        smsActivateURLBuilder.append(SMSActivateURLKey.ID, String.valueOf(rentId));
        String jsonResponseFromServer = new SMSActivateWebClient(this.smsActivateWebClientListener).getOrThrowCommonException(smsActivateURLBuilder, this.validator);
        SMSActivateJsonParser jsonParser = new SMSActivateJsonParser();
        if (this.validator.containsSuccessStatus(jsonResponseFromServer)) {
            SMSActivateErrorResponse errorResponse = (SMSActivateErrorResponse)jsonParser.tryParseJson(jsonResponseFromServer, new TypeToken<SMSActivateErrorResponse>(){}.getType(), this.validator);
            throw this.validator.getBaseExceptionByErrorNameOrUnknown(errorResponse.getMessage(), null);
        }
        return (SMSActivateGetRentStatusResponse)jsonParser.tryParseJson(jsonResponseFromServer, new TypeToken<SMSActivateGetRentStatusResponse>(){}.getType(), this.validator);
    }

    @NotNull
    public SMSActivateGetRentStatusResponse getRentStatus(@NotNull SMSActivateRentActivation rentActivation) throws SMSActivateBaseException {
        return this.getRentStatus(rentActivation.getId());
    }

    @NotNull
    public SMSActivateRentStatus setRentStatus(int rentId, @NotNull SMSActivateClientRentStatus status) throws SMSActivateBaseException {
        SMSActivateURLBuilder smsActivateURLBuilder = new SMSActivateURLBuilder(this.apiKey, SMSActivateAction.SET_RENT_STATUS);
        smsActivateURLBuilder.append(SMSActivateURLKey.ID, String.valueOf(rentId)).append(SMSActivateURLKey.STATUS, String.valueOf(status.getId()));
        String jsonFromServer = new SMSActivateWebClient(this.smsActivateWebClientListener).getOrThrowCommonException(smsActivateURLBuilder, this.validator);
        SMSActivateJsonParser jsonParser = new SMSActivateJsonParser();
        if (this.validator.containsSuccessStatus(jsonFromServer)) {
            SMSActivateErrorResponse response = (SMSActivateErrorResponse)jsonParser.tryParseJson(jsonFromServer, new TypeToken<SMSActivateErrorResponse>(){}.getType(), this.validator);
            throw this.validator.getBaseExceptionByErrorNameOrUnknown(response.getMessage(), null);
        }
        return SMSActivateRentStatus.SUCCESS;
    }

    @NotNull
    public SMSActivateRentStatus setRentStatus(SMSActivateRentActivation rentActivation, @NotNull SMSActivateClientRentStatus status) throws SMSActivateBaseException {
        return this.setRentStatus(rentActivation.getId(), status);
    }

    @NotNull
    public SMSActivateGetRentListResponse getRentList() throws SMSActivateBaseException {
        SMSActivateURLBuilder smsActivateURLBuilder = new SMSActivateURLBuilder(this.apiKey, SMSActivateAction.GET_RENT_LIST);
        String jsonFromServer = new SMSActivateWebClient(this.smsActivateWebClientListener).getOrThrowCommonException(smsActivateURLBuilder, this.validator);
        SMSActivateJsonParser jsonParser = new SMSActivateJsonParser();
        if (this.validator.containsSuccessStatus(jsonFromServer)) {
            SMSActivateErrorResponse smsActivateErrorResponse = (SMSActivateErrorResponse)jsonParser.tryParseJson(jsonFromServer, new TypeToken<SMSActivateErrorResponse>(){}.getType(), this.validator);
            throw this.validator.getBaseExceptionByErrorNameOrUnknown(smsActivateErrorResponse.getMessage(), null);
        }
        return (SMSActivateGetRentListResponse)jsonParser.tryParseJson(jsonFromServer, new TypeToken<SMSActivateGetRentListResponse>(){}.getType(), this.validator);
    }

    @Nullable
    public String waitSms(int activationId, int maxWaitMinutes) throws SMSActivateBaseException {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, maxWaitMinutes);
        SMSActivateGetStatusResponse statusResponse = this.getStatus(activationId);
        while (System.currentTimeMillis() < calendar.getTime().getTime()) {
            if (statusResponse.getSMSActivateGetStatus() == SMSActivateGetStatusActivation.OK && !statusResponse.getCodeFromSMS().equalsIgnoreCase("\u041d\u0435\u0442 \u043a\u043e\u0434\u0430")) {
                return statusResponse.getCodeFromSMS();
            }
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            statusResponse = this.getStatus(activationId);
        }
        return statusResponse.getCodeFromSMS();
    }

    @Nullable
    public String waitSms(@NotNull SMSActivateActivation activation, int maxWaitMinutes) throws SMSActivateBaseException {
        return this.waitSms(activation.getId(), maxWaitMinutes);
    }

    @NotNull
    public List<SMSActivateSMS> waitSmsForRent(@NotNull SMSActivateRentActivation rentActivation, int maxWaitMinutes) throws SMSActivateBaseException {
        return this.waitSmsForRent(rentActivation.getId(), maxWaitMinutes);
    }

    @NotNull
    public List<SMSActivateSMS> waitSmsForRent(int rentId, int maxWaitMinutes) throws SMSActivateBaseException {
        SMSActivateGetRentStatusResponse rentStatus;
        ArrayList<SMSActivateSMS> smsActivateSMS;
        int countSMS;
        Calendar calendar;
        block8: {
            calendar = Calendar.getInstance();
            calendar.add(12, maxWaitMinutes);
            countSMS = 0;
            smsActivateSMS = new ArrayList();
            try {
                rentStatus = this.getRentStatus(rentId);
                countSMS = rentStatus.getCountSms();
                smsActivateSMS = rentStatus.getSmsActivateSMSList();
            }
            catch (SMSActivateBaseException e) {
                if (e.getTypeError() == SMSActivateBaseTypeError.WAIT_CODE) break block8;
                throw e;
            }
        }
        while (System.currentTimeMillis() < calendar.getTime().getTime()) {
            block9: {
                try {
                    rentStatus = this.getRentStatus(rentId);
                    if (rentStatus.getCountSms() != countSMS) {
                        return rentStatus.getSmsActivateSMSList();
                    }
                }
                catch (SMSActivateBaseException e) {
                    if (e.getTypeError() == SMSActivateBaseTypeError.WAIT_CODE) break block9;
                    throw e;
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {}
        }
        return smsActivateSMS;
    }

    @NotNull
    private BigDecimal getBalanceByAction(@NotNull SMSActivateAction smsActivateAction) throws SMSActivateBaseException {
        SMSActivateURLBuilder smsActivateURLBuilder = new SMSActivateURLBuilder(this.apiKey, smsActivateAction);
        String balance = new SMSActivateWebClient(this.smsActivateWebClientListener).getOrThrowCommonException(smsActivateURLBuilder, this.validator);
        Matcher matcher = patternDigit.matcher(balance);
        if (!matcher.find()) {
            throw new SMSActivateBaseException("Error: " + balance, "Error: " + balance);
        }
        return new BigDecimal(matcher.group());
    }
}

