/*
 * Decompiled with CFR 0.152.
 */
package ru.sms_activate;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.sms_activate.SMSActivateAction;
import ru.sms_activate.SMSActivateURLKey;

class SMSActivateURLBuilder {
    private static final String BASE_URL = "https://sms-activate.ru/stubs/handler_api.php?";
    private final Map<SMSActivateURLKey, String> parameterMap;

    public SMSActivateURLBuilder(final @NotNull String apiKey, final @NotNull SMSActivateAction action) {
        this.parameterMap = new HashMap<SMSActivateURLKey, String>(){
            {
                this.put(SMSActivateURLKey.API_KEY, apiKey);
                this.put(SMSActivateURLKey.ACTION, action.getName());
            }
        };
    }

    public SMSActivateURLBuilder append(@NotNull SMSActivateURLKey key, @Nullable String value) {
        if (value == null || value.isEmpty()) {
            return this;
        }
        if (!this.parameterMap.containsKey((Object)key)) {
            this.parameterMap.put(key, value);
        }
        return this;
    }

    @NotNull
    public URL build() throws IOException {
        String urlParameters = this.parameterMap.entrySet().stream().map(entry -> String.join((CharSequence)"=", ((SMSActivateURLKey)((Object)((Object)entry.getKey()))).getName(), (CharSequence)entry.getValue())).collect(Collectors.joining("&"));
        return new URL(BASE_URL + urlParameters);
    }
}

