/*
 * Decompiled with CFR 0.152.
 */
package ru.sms_activate;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.sms_activate.error.SMSActivateBannedException;
import ru.sms_activate.error.SMSActivateUnknownException;
import ru.sms_activate.error.base.SMSActivateBaseException;
import ru.sms_activate.error.base.SMSActivateBaseTypeError;
import ru.sms_activate.error.wrong_parameter.SMSActivateWrongParameter;
import ru.sms_activate.error.wrong_parameter.SMSActivateWrongParameterException;
import ru.sms_activate.listener.SMSActivateExceptionListener;

class SMSActivateValidator {
    public static final String SUCCESS_STATUS = "success";
    private static final String BANNED = "BANNED";
    private static final String SQL = "SQL";
    private SMSActivateExceptionListener smsActivateExceptionListener;

    SMSActivateValidator() {
    }

    public void setSmsActivateExceptionListener(@NotNull SMSActivateExceptionListener smsActivateExceptionListener) {
        this.smsActivateExceptionListener = smsActivateExceptionListener;
    }

    private void throwWrongParameterExceptionByName(@NotNull String name) throws SMSActivateWrongParameterException {
        SMSActivateWrongParameter wrongParameter = SMSActivateWrongParameter.getWrongParameterByName(name);
        if (wrongParameter != SMSActivateWrongParameter.UNKNOWN) {
            if (this.smsActivateExceptionListener != null) {
                this.smsActivateExceptionListener.handle(name);
            }
            throw new SMSActivateWrongParameterException(wrongParameter);
        }
    }

    public void throwCommonExceptionByName(@NotNull String name) throws SMSActivateBaseException {
        this.throwWrongParameterExceptionByName(name);
        if (name.toUpperCase().contains(SQL)) {
            if (this.smsActivateExceptionListener != null) {
                this.smsActivateExceptionListener.handle(name);
            }
            throw new SMSActivateBaseException("Error SQL-server.", "\u041e\u0448\u0438\u0431\u043a\u0430 SQL-\u0441\u0435\u0440\u0432\u0435\u0440\u0430.");
        }
    }

    public void throwExceptionWithBan(@NotNull String name) throws SMSActivateBaseException {
        this.throwCommonExceptionByName(name);
        if (name.toUpperCase().contains(BANNED)) {
            if (this.smsActivateExceptionListener != null) {
                this.smsActivateExceptionListener.handle(name);
            }
            throw new SMSActivateBannedException("Your account has been banned", "\u0412\u0430\u0448 \u0430\u043a\u0430\u0443\u043d\u0442 \u0431\u044b\u043b \u0437\u0430\u0431\u0430\u043d\u0435\u043d", name.split("BANNED:")[1]);
        }
    }

    @NotNull
    public SMSActivateBaseException getBaseExceptionByErrorNameOrUnknown(@NotNull String errorName, @Nullable String message) throws SMSActivateBaseException {
        this.throwCommonExceptionByName(errorName);
        SMSActivateBaseTypeError error = SMSActivateBaseTypeError.getErrorByName(errorName);
        if (this.smsActivateExceptionListener != null) {
            this.smsActivateExceptionListener.handle(errorName);
        }
        if (error != SMSActivateBaseTypeError.UNKNOWN) {
            return new SMSActivateBaseException(error);
        }
        return new SMSActivateUnknownException(errorName, message);
    }

    public boolean containsSuccessStatus(@NotNull String data) {
        return !data.toLowerCase().contains(SUCCESS_STATUS);
    }
}

