/*
 * Decompiled with CFR 0.152.
 */
package ru.sms_activate;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.sms_activate.SMSActivateURLBuilder;
import ru.sms_activate.SMSActivateValidator;
import ru.sms_activate.error.SMSActivateUnknownException;
import ru.sms_activate.error.base.SMSActivateBaseException;
import ru.sms_activate.listener.SMSActivateWebClientListener;

class SMSActivateWebClient {
    private static final AtomicInteger COUNT_REQUEST = new AtomicInteger();
    private final SMSActivateWebClientListener smsActivateWebClientListener;

    public SMSActivateWebClient(@Nullable SMSActivateWebClientListener smsActivateWebClientListener) {
        this.smsActivateWebClientListener = smsActivateWebClientListener;
    }

    @NotNull
    public String getOrThrowCommonException(@NotNull SMSActivateURLBuilder smsActivateURLBuilder, @NotNull SMSActivateValidator validator) throws SMSActivateBaseException {
        try {
            int cid = COUNT_REQUEST.incrementAndGet();
            HttpURLConnection urlConnection = (HttpURLConnection)smsActivateURLBuilder.build().openConnection();
            urlConnection.setRequestMethod("GET");
            urlConnection.setRequestProperty("accept-Encoding", "gzip, json");
            int statusCode = urlConnection.getResponseCode();
            String data = this.load(urlConnection);
            if (this.smsActivateWebClientListener != null) {
                this.smsActivateWebClientListener.handle(cid, urlConnection.getURL().toString(), statusCode, data);
            }
            validator.throwCommonExceptionByName(data);
            return data;
        }
        catch (IOException e) {
            throw new SMSActivateUnknownException("Problems with network connection.", e.getMessage());
        }
    }

    @NotNull
    private String load(@NotNull HttpURLConnection urlConnection) throws IOException {
        InputStreamReader inputStreamReader = urlConnection.getErrorStream() == null ? (urlConnection.getContentEncoding() != null && urlConnection.getContentEncoding().contains("gzip") ? new InputStreamReader(new GZIPInputStream(urlConnection.getInputStream())) : new InputStreamReader(urlConnection.getInputStream())) : new InputStreamReader(new GZIPInputStream(urlConnection.getErrorStream()));
        try (BufferedReader reader = new BufferedReader(inputStreamReader);){
            String data;
            StringBuilder builder = new StringBuilder();
            while ((data = reader.readLine()) != null) {
                builder.append(data);
            }
            String string = builder.toString();
            return string;
        }
    }
}

