/*
 * Decompiled with CFR 0.152.
 */
package ru.sms_activate.error.base;

import org.jetbrains.annotations.NotNull;

public enum SMSActivateBaseTypeError {
    UNKNOWN("", "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043e\u0448\u0438\u0431\u043a\u0438.", "Unknown type error."),
    NO_BALANCE("NO_BALANCE", "\u041d\u0435\u0442 \u0434\u0435\u043d\u0435\u0433 \u043d\u0430 \u0441\u0447\u0435\u0442\u0443.", "There is no money in the account."),
    NO_NUMBERS("NO_NUMBERS", "\u041d\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043d\u043e\u043c\u0435\u0440\u043e\u0432 \u043d\u0435\u0442.", "There are currently no numbers."),
    CANT_CANCEL("CANT_CANCEL", "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0430\u0440\u0435\u043d\u0434\u0443 (\u0431\u043e\u043b\u0435\u0435 20 \u043c\u0438\u043d.).", "It is impossible to cancel the rent(more than 20 min.)."),
    ALREADY_FINISH("ALREADY_FINISH", "\u0410\u0440\u0435\u043d\u0434\u0430 \u0443\u0436\u0435 \u0437\u0430\u0432\u0435\u0440\u0449\u0435\u043d\u0430.", "Rent has already been finished."),
    ALREADY_CANCEL("ALREADY_CANCEL", "\u0410\u0440\u0435\u043d\u0434\u0430 \u0443\u0436\u0435 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430.", "Rent has already been canceled."),
    WAIT_CODE("STATUS_WAIT_CODE", "\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0432\u043e\u0439 \u0441\u043c\u0441", "Waiting for the first SMS."),
    RENT_CANCEL("STATUS_CANCEL", "\u0410\u0440\u0435\u043d\u0434\u0430 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430 \u0441 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u043e\u043c \u0434\u0435\u043d\u0435\u0433.", "Rent canceled with a refund."),
    RENT_FINISH("STATUS_FINISH", "\u0410\u0440\u0435\u043d\u0434\u0430 \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u0430 \u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u0430.", "Rent has been paid and finished");

    private final String englishMessage;
    private final String russianMessage;
    private final String response;

    private SMSActivateBaseTypeError(@NotNull String response, String russianMessage, String englishMessage) {
        this.response = response;
        this.englishMessage = englishMessage;
        this.russianMessage = russianMessage;
    }

    @NotNull
    public String getEnglishMessage() {
        return this.englishMessage;
    }

    @NotNull
    public String getRussianMessage() {
        return this.russianMessage;
    }

    @NotNull
    public String getMessage() {
        return String.join((CharSequence)" | ", this.englishMessage, this.russianMessage);
    }

    @NotNull
    public String getResponse() {
        return this.response;
    }

    @NotNull
    public static SMSActivateBaseTypeError getErrorByName(@NotNull String name) {
        name = name.toUpperCase();
        for (SMSActivateBaseTypeError status : SMSActivateBaseTypeError.values()) {
            if (!status.getResponse().equals(name)) continue;
            return status;
        }
        return UNKNOWN;
    }
}

