/*
 * Decompiled with CFR 0.152.
 */
package ru.sms_activate.response.api_activation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import ru.sms_activate.error.wrong_parameter.SMSActivateWrongParameterException;
import ru.sms_activate.response.api_activation.extra.SMSActivateServiceInfo;

public class SMSActivateGetNumbersStatusResponse {
    private final Map<String, SMSActivateServiceInfo> smsActivateServiceInfoMap;

    public SMSActivateGetNumbersStatusResponse(@NotNull Map<String, SMSActivateServiceInfo> smsActivateServiceInfoMap) {
        this.smsActivateServiceInfoMap = smsActivateServiceInfoMap;
    }

    @NotNull
    public SMSActivateServiceInfo getSMSActivateServiceInfoByShortName(@NotNull String serviceName) throws SMSActivateWrongParameterException {
        return this.getSMSActivateServiceInfoByShortNameAndForward(serviceName, false);
    }

    @NotNull
    public SMSActivateServiceInfo getSMSActivateServiceForwardInfoByShortName(@NotNull String serviceName) throws SMSActivateWrongParameterException {
        return this.getSMSActivateServiceInfoByShortNameAndForward(serviceName, true);
    }

    @NotNull
    private SMSActivateServiceInfo getSMSActivateServiceInfoByShortNameAndForward(@NotNull String serviceName, boolean forward) throws SMSActivateWrongParameterException {
        SMSActivateServiceInfo smsActivateServiceInfo = this.smsActivateServiceInfoMap.get(serviceName + "_" + (forward ? "1" : "0"));
        if (smsActivateServiceInfo == null) {
            throw new SMSActivateWrongParameterException("Wrong service short name.", "\u041d\u0435\u043a\u043a\u043e\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u043a\u043e\u0440\u043e\u0442\u043a\u043e\u0435 \u0438\u043c\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u0430.");
        }
        return smsActivateServiceInfo;
    }

    @NotNull
    public List<SMSActivateServiceInfo> getAllServiceInfoList() {
        return new ArrayList<SMSActivateServiceInfo>(this.smsActivateServiceInfoMap.values());
    }
}

