/*
 * Decompiled with CFR 0.152.
 */
package ru.sms_activate.response.api_activation;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import ru.sms_activate.error.base.SMSActivateBaseException;
import ru.sms_activate.error.wrong_parameter.SMSActivateWrongParameterException;
import ru.sms_activate.response.api_activation.extra.SMSActivateGetPriceInfo;

public class SMSActivateGetPricesResponse {
    private final Map<Integer, Map<String, SMSActivateGetPriceInfo>> smsActivateGetPriceMap;

    public SMSActivateGetPricesResponse(@NotNull Map<Integer, Map<String, SMSActivateGetPriceInfo>> smsActivateGetPriceMap) {
        this.smsActivateGetPriceMap = smsActivateGetPriceMap;
    }

    @NotNull
    public SMSActivateGetPriceInfo getPriceInfo(int countryId, @NotNull String serviceName) throws SMSActivateBaseException {
        SMSActivateGetPriceInfo smsActivateGetPriceInfo = this.getSmsActivateGetPriceMap(countryId).get(serviceName);
        if (smsActivateGetPriceInfo == null) {
            throw new SMSActivateWrongParameterException("Wrong service name.", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u0430.");
        }
        return smsActivateGetPriceInfo;
    }

    @NotNull
    public Map<String, SMSActivateGetPriceInfo> getSmsActivateGetPriceMap(@NotNull Integer countryId) throws SMSActivateWrongParameterException {
        Map<String, SMSActivateGetPriceInfo> smsActivateGetPriceInfoMap = this.smsActivateGetPriceMap.get(countryId);
        if (smsActivateGetPriceInfoMap == null) {
            throw new SMSActivateWrongParameterException("Wrong country id", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 id \u0441\u0442\u0440\u0430\u043d\u044b");
        }
        return smsActivateGetPriceInfoMap;
    }

    @NotNull
    public SortedSet<Integer> getCountryIdSet() {
        return new TreeSet<Integer>(this.smsActivateGetPriceMap.keySet());
    }

    @NotNull
    public Set<String> getServicesByCountryId(@NotNull Integer countryId) throws SMSActivateWrongParameterException {
        return new HashSet<String>(this.getSmsActivateGetPriceMap(countryId).keySet());
    }
}

