/*
 * Decompiled with CFR 0.152.
 */
package ru.sms_activate.response.api_activation.enums;

import org.jetbrains.annotations.NotNull;

public enum SMSActivateServerStatus {
    READY("ACCESS_READY", "\u0413\u043e\u0442\u043e\u0432\u043d\u043e\u0441\u0442\u044c \u043d\u043e\u043c\u0435\u0440\u0430 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0430.", "Number readiness confirmed."),
    RETRY_GET("ACCESS_RETRY_GET", "\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0433\u043e \u0441\u043c\u0441.", "Wait new sms."),
    FINISH("ACCESS_ACTIVATION", "\u0421\u0435\u0440\u0432\u0438\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d.", "The service has been successfully activated."),
    CANCEL("ACCESS_CANCEL", "\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0431\u044b\u043b\u0430 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430.", "Activation has been canceled."),
    SMS_ADDED("SMS_ADDED", "\u0421\u041c\u0421 \u0431\u044b\u043b\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430.", "SMS has been added."),
    UNKNOWN("UNKNOWN", "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438.", "Unknown status activation.");

    private final String response;
    private final String russianMessage;
    private final String englishMessage;

    private SMSActivateServerStatus(@NotNull String response, String russianMessage, String englishMessage) {
        this.response = response;
        this.russianMessage = russianMessage;
        this.englishMessage = englishMessage;
    }

    @NotNull
    public String getRussianMessage() {
        return this.russianMessage;
    }

    @NotNull
    public String getEnglishMessage() {
        return this.englishMessage;
    }

    @NotNull
    public String getMessage() {
        return String.join((CharSequence)" | ", this.englishMessage, this.russianMessage);
    }

    @NotNull
    public String getResponse() {
        return this.response;
    }

    @NotNull
    public static SMSActivateServerStatus getStatusByName(@NotNull String name) {
        name = name.toUpperCase();
        for (SMSActivateServerStatus accessStatusActivation : SMSActivateServerStatus.values()) {
            if (!accessStatusActivation.getResponse().equals(name)) continue;
            return accessStatusActivation;
        }
        return UNKNOWN;
    }
}

