/*
 * Decompiled with CFR 0.152.
 */
package ru.sms_activate.response.api_activation.enums;

import org.jetbrains.annotations.NotNull;

public enum SMSActivateStatusNumber {
    WAIT_CODE("STATUS_WAIT_CODE", "\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u0441\u043c\u0441.", "Waiting sms."),
    CANCEL("STATUS_CANCEL", "\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430.", "Activation canceled."),
    FULL_SMS("FULL_SMS", "\u041f\u043e\u043b\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442 \u0441\u043c\u0441.", "Full text sms."),
    UNKNOWN("UNKNOWN", "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438.", "Unknown status activation.");

    private final String response;
    private final String russianMessage;
    private final String englishMessage;

    private SMSActivateStatusNumber(@NotNull String response, String russianMessage, String englishMessage) {
        this.response = response;
        this.russianMessage = russianMessage;
        this.englishMessage = englishMessage;
    }

    @NotNull
    public String getRussianMessage() {
        return this.russianMessage;
    }

    @NotNull
    public String getEnglishMessage() {
        return this.englishMessage;
    }

    @NotNull
    public String getMessage() {
        return String.join((CharSequence)" | ", this.englishMessage, this.russianMessage);
    }

    @NotNull
    public String getResponse() {
        return this.response;
    }

    @NotNull
    public static SMSActivateStatusNumber getStatusByName(@NotNull String name) {
        if ((name = name.toUpperCase()).startsWith(FULL_SMS.getResponse())) {
            return FULL_SMS;
        }
        for (SMSActivateStatusNumber statusNumber : SMSActivateStatusNumber.values()) {
            if (!name.contains(statusNumber.getResponse())) continue;
            return statusNumber;
        }
        return UNKNOWN;
    }
}

