/*
 * Decompiled with CFR 0.152.
 */
package ru.sms_activate.response.api_rent;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import ru.sms_activate.error.wrong_parameter.SMSActivateWrongParameterException;
import ru.sms_activate.response.api_rent.extra.SMSActivateRentService;

public class SMSActivateGetRentServicesAndCountriesResponse {
    private Map<Integer, String> operators;
    private Map<Integer, Integer> countries;
    private Map<String, SMSActivateRentService> services;

    private SMSActivateGetRentServicesAndCountriesResponse() {
    }

    @NotNull
    public SMSActivateRentService getRentServiceByShortName(@NotNull String serviceShortName) throws SMSActivateWrongParameterException {
        SMSActivateRentService rentService = this.services.get(serviceShortName);
        if (rentService == null) {
            throw new SMSActivateWrongParameterException("Service name is incorrect", "\u041d\u0435\u043a\u043a\u043e\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u0430.");
        }
        return rentService;
    }

    @NotNull
    public Map<String, SMSActivateRentService> getAllRentServices() {
        return this.services;
    }

    @NotNull
    public Set<String> getRentServiceNameSet() {
        return this.services.keySet();
    }

    @NotNull
    public SortedSet<Integer> getCountryIdSet() {
        return new TreeSet<Integer>(this.countries.values());
    }

    @NotNull
    public Set<String> getOperatorNameSet() {
        return new HashSet<String>(this.operators.values());
    }
}

