/*
 * Decompiled with CFR 0.152.
 */
package ru.sms_activate.response.qiwi;

import org.jetbrains.annotations.NotNull;
import ru.sms_activate.error.SMSActivateUnknownException;

public enum SMSActivateQiwiStatus {
    SUCCESS("SUCCESS", "\u041e\u043f\u043b\u0430\u0442\u0443 \u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0432\u043e\u0434\u0438\u0442\u044c.", "Payment can be made."),
    FALSE("FALSE", "\u041f\u0440\u0438\u0435\u043c \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u043a\u0438\u0432\u0438 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.", "Acceptance of qiwi payments is not possible.");

    private final String response;
    private final String russianMessage;
    private final String englishMessage;

    private SMSActivateQiwiStatus(@NotNull String response, String russianMessage, String englishMessage) {
        this.response = response;
        this.russianMessage = russianMessage;
        this.englishMessage = englishMessage;
    }

    @NotNull
    public String getRussianMessage() {
        return this.russianMessage;
    }

    @NotNull
    public String getEnglishMessage() {
        return this.englishMessage;
    }

    @NotNull
    public String getMessage() {
        return String.join((CharSequence)" | ", this.englishMessage, this.russianMessage);
    }

    @NotNull
    public String getResponse() {
        return this.response;
    }

    @NotNull
    public static SMSActivateQiwiStatus getStatusByName(@NotNull String response) throws SMSActivateUnknownException {
        for (SMSActivateQiwiStatus status : SMSActivateQiwiStatus.values()) {
            if (!status.getResponse().equalsIgnoreCase(response)) continue;
            return status;
        }
        throw new SMSActivateUnknownException(response, "Unknown status of qiwi wallet.");
    }
}

