package ru.tbank.posterminal.p2psdk

import android.os.Bundle
import java.util.UUID

internal fun Bundle.appendData(
    transactionData: TransactionData,
): Bundle = apply {
    val uuid = UUID.randomUUID().toString()
    putLong(AMOUNT_KEY, transactionData.amount)
    putString(UUID_KEY, uuid)
    if (transactionData is RefundTransactionData) {
        val key = when (transactionData.paymentMethod) {
            PaymentMethod.NFC -> RRN_KEY
            PaymentMethod.QR -> PAYMENT_ID_KEY
            else -> error("Incorrect paymentMethod in refund case")
        }

        putLong(key, transactionData.transactionId)
        putLong(MERCHANT_ID_KEY, transactionData.mid)
    }
}

@Suppress("DEPRECATION")
internal fun Bundle.toStringFormat() = keySet().joinToString(
    prefix = "{",
    postfix = "}"
) { k -> "$k=${this[k]}" }
