package ru.tbank.posterminal.p2psdk

import android.os.Message
import android.os.Messenger
import kotlin.contracts.ExperimentalContracts
import kotlin.contracts.contract

internal var Message.clientPackage
    get() = data.getString("package") ?: error("Need to specify package name")
    set(value) = data.putString("package", value)

internal fun Message.toSoftposResult(): SoftposResult {
    check(what == IPC_RESULT_SUCCESS) { "Message is not payment result message" }
    return when (arg1) {
        IPC_A1_PAYMENT -> when (arg2) {
            IPC_A2_NFC -> SoftposResult(data, PaymentMethod.NFC, RRN_KEY, isRefund = false)
            IPC_A2_QR -> SoftposResult(
                data,
                PaymentMethod.QR,
                PAYMENT_ID_KEY,
                isRefund = false
            )

            else -> error("Payment: incorrect arg2=$arg2 in message")
        }

        IPC_A1_REFUND -> when (arg2) {
            IPC_A2_NFC -> SoftposResult(data, PaymentMethod.NFC, RRN_KEY, isRefund = true)
            IPC_A2_QR -> SoftposResult(
                data,
                PaymentMethod.QR,
                PAYMENT_ID_KEY,
                isRefund = true
            )

            else -> error("Refund: incorrect arg2=$arg2 in message")
        }

        else -> error("Incorrect arg1=$arg1 in message")
    }
}

internal fun Message.isPayment() = arg1 == IPC_A1_PAYMENT
internal fun Message.toTransactionException() =
    SoftposException(
        code = data.getInt(ERROR_CODE_KEY, REJECT_BY_USER_ERROR_CODE),
        details = data.getString(ERROR_MESSAGE_KEY)
    )

@OptIn(ExperimentalContracts::class)
internal fun Messenger?.isBound(): Boolean {
    contract { returns(true) implies (this@isBound is Messenger) }
    return this?.binder?.isBinderAlive == true
}
