package ru.tbank.posterminal.p2psdk

public sealed interface TransactionData {
    public val amount: Long
    public val paymentMethod: PaymentMethod
}

public data class PaymentTransactionData(
    override val amount: Long,
    override val paymentMethod: PaymentMethod = PaymentMethod.UNDEFINED
) : TransactionData

public data class RefundTransactionData(
    override val amount: Long,
    override val paymentMethod: PaymentMethod,
    public val transactionId: Long,
    public val mid: Long
) : TransactionData
