/*
 * Decompiled with CFR 0.152.
 */
package ru.tbank.posterminal.p2psdk;

import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tbank.posterminal.p2psdk.BundleExtKt;
import ru.tbank.posterminal.p2psdk.Callback;
import ru.tbank.posterminal.p2psdk.MessageExtKt;
import ru.tbank.posterminal.p2psdk.PaymentMethod;
import ru.tbank.posterminal.p2psdk.R;
import ru.tbank.posterminal.p2psdk.RefundTransactionData;
import ru.tbank.posterminal.p2psdk.SoftposException;
import ru.tbank.posterminal.p2psdk.TLogger;
import ru.tbank.posterminal.p2psdk.TSoftposManager;
import ru.tbank.posterminal.p2psdk.TransactionData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0002\f\u0012\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001a\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u000f2\b\u0010&\u001a\u0004\u0018\u00010\nH\u0002J\u0018\u0010'\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"H\u0002J\u0006\u0010(\u001a\u00020\u0018J\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010*2\u0006\u0010!\u001a\u00020\"H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lru/tbank/posterminal/p2psdk/TSoftposManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "callback", "Lru/tbank/posterminal/p2psdk/Callback;", "clientMessenger", "Landroid/os/Messenger;", "clientPackage", "", "handler", "ru/tbank/posterminal/p2psdk/TSoftposManager$handler$1", "Lru/tbank/posterminal/p2psdk/TSoftposManager$handler$1;", "isTransactionInProgress", "", "()Z", "serviceConnection", "ru/tbank/posterminal/p2psdk/TSoftposManager$serviceConnection$1", "Lru/tbank/posterminal/p2psdk/TSoftposManager$serviceConnection$1;", "softposMessenger", "tLogger", "Lru/tbank/posterminal/p2psdk/TLogger;", "bindSoftpos", "", "activityContext", "onReadyToTransact", "Ljava/lang/Runnable;", "getAmountString", "amount", "", "initLogger", "payToPhone", "transactionData", "Lru/tbank/posterminal/p2psdk/TransactionData;", "payToPhoneIPC", "sendHealthCheckResult", "isRegistered", "packageName", "startActivityIfPossible", "unbindSoftpos", "validateAmount", "Lru/tbank/posterminal/p2psdk/SoftposException;", "validateMidAndTransactionId", "p2p-sdk-1.0.2_release"})
@SourceDebugExtension(value={"SMAP\nTSoftposManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TSoftposManager.kt\nru/tbank/posterminal/p2psdk/TSoftposManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,372:1\n1#2:373\n*E\n"})
public final class TSoftposManager {
    @NotNull
    private final Context context;
    @Nullable
    private volatile Callback callback;
    @Nullable
    private volatile Messenger softposMessenger;
    @Nullable
    private volatile TLogger tLogger;
    @Nullable
    private volatile String clientPackage;
    @NotNull
    private final serviceConnection.1 serviceConnection;
    @NotNull
    private final handler.1 handler;
    @NotNull
    private final Messenger clientMessenger;

    public TSoftposManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.serviceConnection = new ServiceConnection(this){
            @Nullable
            private Runnable onReadyToTransact;
            final /* synthetic */ TSoftposManager this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public final Runnable getOnReadyToTransact() {
                return this.onReadyToTransact;
            }

            public final void setOnReadyToTransact(@Nullable Runnable runnable) {
                this.onReadyToTransact = runnable;
            }

            public void onServiceConnected(@Nullable ComponentName name, @Nullable IBinder service) {
                TLogger tLogger = TSoftposManager.access$getTLogger$p(this.this$0);
                if (tLogger != null) {
                    tLogger.logInfo("TSoftposManager", "Service connected");
                }
                TSoftposManager.access$setSoftposMessenger$p(this.this$0, new Messenger(service));
                Runnable runnable = this.onReadyToTransact;
                if (runnable != null) {
                    runnable.run();
                }
                this.onReadyToTransact = null;
            }

            public void onServiceDisconnected(@Nullable ComponentName name) {
                TLogger tLogger = TSoftposManager.access$getTLogger$p(this.this$0);
                if (tLogger != null) {
                    tLogger.logInfo("TSoftposManager", "onServiceDisconnected: " + name);
                }
                this.this$0.unbindSoftpos();
            }

            public void onBindingDied(@Nullable ComponentName name) {
                TLogger tLogger = TSoftposManager.access$getTLogger$p(this.this$0);
                if (tLogger != null) {
                    tLogger.logInfo("TSoftposManager", "onBindingDied: " + name);
                }
                this.this$0.unbindSoftpos();
            }

            public void onNullBinding(@Nullable ComponentName name) {
                TLogger tLogger = TSoftposManager.access$getTLogger$p(this.this$0);
                if (tLogger != null) {
                    tLogger.logInfo("TSoftposManager", "onNullBinding: " + name);
                }
                this.this$0.unbindSoftpos();
            }
        };
        Looper looper = Looper.getMainLooper();
        this.handler = new Handler(this, looper){
            final /* synthetic */ TSoftposManager this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(@NotNull Message msg) {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                TLogger tLogger = TSoftposManager.access$getTLogger$p(this.this$0);
                if (tLogger != null) {
                    int n = msg.what;
                    int n2 = msg.arg1;
                    int n3 = msg.arg2;
                    Bundle bundle = msg.getData();
                    Intrinsics.checkNotNullExpressionValue((Object)bundle, (String)"getData(...)");
                    tLogger.logDebug("TSoftposManager", "Received message what: " + n + ", arg1: " + n2 + ", arg2: " + n3 + ", data: " + BundleExtKt.toStringFormat(bundle));
                }
                switch (msg.what) {
                    case 3: {
                        try {
                            Callback callback = TSoftposManager.access$getCallback$p(this.this$0);
                            boolean isRegistered = callback != null ? callback.onTransactionRegistered(MessageExtKt.toSoftposResult(msg)) : false;
                            TLogger tLogger2 = TSoftposManager.access$getTLogger$p(this.this$0);
                            if (tLogger2 != null) {
                                tLogger2.logDebug("TSoftposManager", "isRegistered: " + isRegistered);
                            }
                            if (!MessageExtKt.isPayment(msg)) break;
                            TSoftposManager.access$sendHealthCheckResult(this.this$0, isRegistered, TSoftposManager.access$getClientPackage$p(this.this$0));
                            break;
                        }
                        catch (Exception e) {
                            Callback callback = TSoftposManager.access$getCallback$p(this.this$0);
                            if (callback != null) {
                                callback.onError(e);
                            }
                            break;
                        }
                        finally {
                            TSoftposManager.access$setCallback$p(this.this$0, null);
                        }
                    }
                    case 4: {
                        Callback callback = TSoftposManager.access$getCallback$p(this.this$0);
                        if (callback != null) {
                            callback.onError(MessageExtKt.toTransactionException(msg));
                        }
                        TSoftposManager.access$setCallback$p(this.this$0, null);
                    }
                }
            }
        };
        this.clientMessenger = new Messenger((Handler)this.handler);
    }

    public final boolean isTransactionInProgress() {
        return this.callback != null;
    }

    public final void unbindSoftpos() {
        block3: {
            TLogger tLogger = this.tLogger;
            if (tLogger != null) {
                tLogger.logDebug("TSoftposManager", "Unbind service");
            }
            this.handler.removeCallbacksAndMessages(null);
            this.softposMessenger = null;
            this.callback = null;
            try {
                this.context.unbindService((ServiceConnection)this.serviceConnection);
            }
            catch (IllegalArgumentException e) {
                TLogger tLogger2 = this.tLogger;
                if (tLogger2 == null) break block3;
                tLogger2.logDebug("TSoftposManager", "Service was not bound: " + e);
            }
        }
    }

    public final void payToPhone(@NotNull TransactionData transactionData, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)transactionData, (String)"transactionData");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        TLogger tLogger = this.tLogger;
        if (tLogger != null) {
            tLogger.logDebug("TSoftposManager", "payToPhone(): " + transactionData + ", isTransactionInProgress=" + this.isTransactionInProgress());
        }
        if (this.isTransactionInProgress()) {
            callback.onError(new IllegalStateException("Transaction is already in progress!"));
            return;
        }
        SoftposException softposException = this.validateAmount(transactionData, this.context);
        if (softposException != null) {
            SoftposException error = softposException;
            boolean bl = false;
            callback.onError(error);
            return;
        }
        softposException = this.validateMidAndTransactionId(transactionData);
        if (softposException != null) {
            SoftposException error = softposException;
            boolean bl = false;
            callback.onError(error);
            return;
        }
        this.callback = callback;
        try {
            this.bindSoftpos(this.context, () -> TSoftposManager.payToPhone$lambda$2(this, transactionData));
        }
        catch (Exception e) {
            callback.onError(e);
            this.callback = null;
        }
    }

    public final void initLogger(@NotNull TLogger tLogger) {
        Intrinsics.checkNotNullParameter((Object)tLogger, (String)"tLogger");
        this.tLogger = tLogger;
    }

    private final void bindSoftpos(Context activityContext, Runnable onReadyToTransact) {
        if (MessageExtKt.isBound(this.softposMessenger)) {
            onReadyToTransact.run();
        } else {
            Intent intent;
            Intent $this$bindSoftpos_u24lambda_u243 = intent = new Intent("ru.tbank.posterminal.action.PAY_TO_PHONE");
            boolean bl = false;
            $this$bindSoftpos_u24lambda_u243.setPackage("ru.tinkoff.posterminal");
            Intent intent2 = intent;
            this.serviceConnection.setOnReadyToTransact(onReadyToTransact);
            boolean isBound = activityContext.bindService(intent2, (ServiceConnection)this.serviceConnection, 65);
            if (!isBound) {
                Callback callback = this.callback;
                if (callback != null) {
                    callback.onError(new IllegalStateException("Failed to bind to Pay to phone (ru.tinkoff.posterminal)!"));
                }
                this.unbindSoftpos();
            }
        }
    }

    private final void startActivityIfPossible(Context context, TransactionData transactionData) {
        Intent intent;
        this.payToPhoneIPC(transactionData, context);
        Intent $this$startActivityIfPossible_u24lambda_u244 = intent = new Intent("ru.tbank.posterminal.action.PAYMENT");
        boolean bl = false;
        $this$startActivityIfPossible_u24lambda_u244.addFlags(0x800000);
        if (context instanceof Application) {
            $this$startActivityIfPossible_u24lambda_u244.addFlags(0x10000000);
        }
        Intent intent2 = intent;
        context.startActivity(intent2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void payToPhoneIPC(TransactionData transactionData, Context context) {
        Message message;
        Messenger messenger = this.softposMessenger;
        if (!MessageExtKt.isBound(messenger)) {
            boolean $i$a$-check-TSoftposManager$payToPhoneIPC$22 = false;
            String $i$a$-check-TSoftposManager$payToPhoneIPC$22 = "Messenger is not bound. Did you forget to call bindSoftpos()?";
            throw new IllegalStateException($i$a$-check-TSoftposManager$payToPhoneIPC$22.toString());
        }
        PaymentMethod paymentMethod = transactionData.getPaymentMethod();
        Long transactionId = transactionData instanceof RefundTransactionData ? Long.valueOf(((RefundTransactionData)transactionData).getTransactionId()) : null;
        this.clientPackage = context.getPackageName();
        Message $this$payToPhoneIPC_u24lambda_u246 = message = Message.obtain(null, (int)2);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$payToPhoneIPC_u24lambda_u246);
        String string2 = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPackageName(...)");
        MessageExtKt.setClientPackage($this$payToPhoneIPC_u24lambda_u246, string2);
        $this$payToPhoneIPC_u24lambda_u246.replyTo = this.clientMessenger;
        $this$payToPhoneIPC_u24lambda_u246.arg1 = transactionId != null ? 2 : 1;
        $this$payToPhoneIPC_u24lambda_u246.arg2 = paymentMethod.getIpcArgValue$p2p_sdk_1_0_2_release();
        Bundle bundle = $this$payToPhoneIPC_u24lambda_u246.getData();
        Intrinsics.checkNotNullExpressionValue((Object)bundle, (String)"getData(...)");
        BundleExtKt.appendData(bundle, transactionData);
        Message message2 = message;
        try {
            messenger.send(message2);
        }
        catch (RemoteException e) {
            TLogger tLogger = this.tLogger;
            if (tLogger != null) {
                tLogger.logError("TSoftposManager", "Send message", e);
            }
            throw e;
        }
        finally {
            message2.recycle();
        }
    }

    private final SoftposException validateAmount(TransactionData transactionData, Context context) {
        PaymentMethod paymentMethod;
        long amount = transactionData.getAmount();
        if (amount < (paymentMethod = transactionData.getPaymentMethod()).getMinAmount() || amount > paymentMethod.getMaxAmount()) {
            CharSequence charSequence = context.getPackageManager().getApplicationLabel(context.getApplicationInfo());
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getApplicationLabel(...)");
            CharSequence applicationName = charSequence;
            Object[] objectArray = new Object[]{this.getAmountString(paymentMethod.getMinAmount(), context), this.getAmountString(paymentMethod.getMaxAmount(), context), applicationName};
            return new SoftposException(2001, context.getString(R.string.pay_to_phone_sdk_invalid_amount, objectArray));
        }
        return null;
    }

    private final SoftposException validateMidAndTransactionId(TransactionData transactionData) {
        if (transactionData instanceof RefundTransactionData) {
            long tid = ((RefundTransactionData)transactionData).getTransactionId();
            long mid = ((RefundTransactionData)transactionData).getMid();
            if (tid <= 0L) {
                return new SoftposException(2001, "Incorrect transactionId=" + tid);
            }
            if (mid <= 0L) {
                return new SoftposException(2001, "Incorrect mid=" + mid);
            }
        }
        return null;
    }

    private final String getAmountString(long amount, Context context) {
        String string2;
        long rub = amount / (long)100;
        long cop = amount % (long)100;
        if (cop == 0L) {
            Object[] objectArray = new Object[]{rub};
            String string3 = context.getString(R.string.pay_to_phone_sdk_amount_part_rub, objectArray);
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        } else {
            String string4;
            if (rub == 0L) {
                var9_6 = new Object[]{cop};
                string4 = context.getString(R.string.pay_to_phone_sdk_amount_part_cop, var9_6);
            } else {
                var9_6 = new Object[]{rub, cop};
                string4 = context.getString(R.string.pay_to_phone_sdk_amount_part_rub_cop, var9_6);
            }
            String string5 = string4;
            Intrinsics.checkNotNull((Object)string5);
            string2 = string5;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendHealthCheckResult(boolean isRegistered, String packageName) {
        Message $i$a$-check-TSoftposManager$sendHealthCheckResult$422;
        Messenger messenger = this.softposMessenger;
        if (!MessageExtKt.isBound(messenger)) {
            boolean $i$a$-check-TSoftposManager$sendHealthCheckResult$32 = false;
            String $i$a$-check-TSoftposManager$sendHealthCheckResult$32 = "Messenger is not bound. Did you forget to call bindSoftpos()?";
            throw new IllegalStateException($i$a$-check-TSoftposManager$sendHealthCheckResult$32.toString());
        }
        CharSequence charSequence = packageName;
        if (!(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)))) {
            boolean $i$a$-check-TSoftposManager$sendHealthCheckResult$422 = false;
            String $i$a$-check-TSoftposManager$sendHealthCheckResult$422 = "Package name is null or empty";
            throw new IllegalStateException($i$a$-check-TSoftposManager$sendHealthCheckResult$422.toString());
        }
        Message $this$sendHealthCheckResult_u24lambda_u249 = $i$a$-check-TSoftposManager$sendHealthCheckResult$422 = Message.obtain(null, (int)5);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$sendHealthCheckResult_u24lambda_u249);
        MessageExtKt.setClientPackage($this$sendHealthCheckResult_u24lambda_u249, packageName);
        $this$sendHealthCheckResult_u24lambda_u249.replyTo = this.clientMessenger;
        $this$sendHealthCheckResult_u24lambda_u249.arg1 = isRegistered ? 6 : 7;
        Message message = $i$a$-check-TSoftposManager$sendHealthCheckResult$422;
        try {
            messenger.send(message);
        }
        catch (RemoteException e) {
            TLogger tLogger = this.tLogger;
            if (tLogger != null) {
                tLogger.logError("TSoftposManager", "Send health check message failed", e);
            }
            throw e;
        }
        finally {
            message.recycle();
        }
    }

    private static final void payToPhone$lambda$2(TSoftposManager this$0, TransactionData $transactionData) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$transactionData, (String)"$transactionData");
        this$0.startActivityIfPossible(this$0.context, $transactionData);
    }

    public static final /* synthetic */ TLogger access$getTLogger$p(TSoftposManager $this) {
        return $this.tLogger;
    }

    public static final /* synthetic */ void access$setSoftposMessenger$p(TSoftposManager $this, Messenger messenger) {
        $this.softposMessenger = messenger;
    }

    public static final /* synthetic */ Callback access$getCallback$p(TSoftposManager $this) {
        return $this.callback;
    }

    public static final /* synthetic */ void access$sendHealthCheckResult(TSoftposManager $this, boolean isRegistered, String packageName) {
        $this.sendHealthCheckResult(isRegistered, packageName);
    }

    public static final /* synthetic */ String access$getClientPackage$p(TSoftposManager $this) {
        return $this.clientPackage;
    }

    public static final /* synthetic */ void access$setCallback$p(TSoftposManager $this, Callback callback) {
        $this.callback = callback;
    }
}

