package ru.tbank.posterminal.p2psdk

import android.os.Bundle
import java.util.UUID

internal fun Bundle.appendData(
    transactionData: TransactionData,
): Bundle = apply {
    val uuid = UUID.randomUUID().toString()
    putLong(AMOUNT_KEY, transactionData.amount)
    putString(UUID_KEY, uuid)
    val mid = transactionData.mid
    if (mid != null) {
        putLong(MERCHANT_ID_KEY, mid)
    }
    if (transactionData is RefundTransactionData) {
        val key = when (transactionData.paymentMethod) {
            PaymentMethod.NFC -> RRN_KEY
            PaymentMethod.QR -> PAYMENT_ID_KEY
            else -> error("Incorrect paymentMethod in refund case")
        }

        putLong(key, transactionData.transactionId)
    }
}

@Suppress("DEPRECATION")
internal fun Bundle.toStringFormat() = keySet().joinToString(
    prefix = "{",
    postfix = "}"
) { k -> "$k=${this[k]}" }
