package ru.tbank.posterminal.p2psdk

public interface Callback {
    /**
     * Called when the transaction is successfully registered with the Softpos service.
     *
     * #### Behavior:
     * - **`true`**: Confirms the transaction and allows it to proceed.
     * - **`false`**: Cancels the transaction. Softpos will automatically handle the cancellation.
     *
     * **Note**: This callback must complete within 1 second. If it takes longer, the transaction will be automatically cancelled.
     *
     * **DO NOT engage network operations here!**
     *
     * @param softposResult Details of the registered transaction.
     * @return `true` to proceed or `false` to cancel transaction.
     */

    public fun onTransactionRegistered(softposResult: SoftposResult): Boolean

    public fun onError(e: Throwable)
}
