package ru.tbank.posterminal.p2psdk

public enum class PaymentMethod(
    internal val ipcArgValue: Int,
    public val minAmount: Long,
    public val maxAmount: Long
) {
    NFC(
        IPC_A2_NFC,
        MIN_MONEY_AMOUNT_NFC,
        MAX_MONEY_AMOUNT_NFC
    ),
    QR(
        IPC_A2_QR,
        MIN_MONEY_AMOUNT_QR,
        MAX_MONEY_AMOUNT_QR
    ),
    UNDEFINED(
        IPC_A2_UNDEFINED,
        MIN_MONEY_AMOUNT_QR,
        MAX_MONEY_AMOUNT_NFC
    )
}
