package ru.tbank.posterminal.p2psdk

import android.os.Bundle

@Suppress("detekt:LongParameterList")
public data class SoftposResult internal constructor(
    public val amount: Long,
    public val dateTime: String,
    public val isRefund: Boolean,
    public val mid: Long,
    public val paymentMethod: PaymentMethod,
    public val transactionId: Long,
    public val tid: Long
)

internal fun SoftposResult(
    bundle: Bundle,
    paymentMethod: PaymentMethod,
    transactionKey: String,
    isRefund: Boolean
): SoftposResult {
    val transactionId = bundle.getLong(transactionKey)
    check(transactionId > 0L) { "Incorrect success message: transactionId=$transactionId, paymentMethod=$paymentMethod" }

    val amount = bundle.getLong(AMOUNT_KEY)
    check(amount > 0L) { "Incorrect success message: amount=$amount, paymentMethod=$paymentMethod" }

    val dateTime = bundle.getString(DATE_TIME_KEY)
    check(!dateTime.isNullOrBlank()) { "Incorrect success message: dateTime=$dateTime, paymentMethod=$paymentMethod" }

    val tid = bundle.getLong(TERMINAL_ID_KEY)
    check(tid > 0L) { "Incorrect success message: tid=$tid, paymentMethod=$paymentMethod" }

    val mid = bundle.getLong(MERCHANT_ID_KEY)
    check(mid > 0L) { "Incorrect success message: mid=$mid, paymentMethod=$paymentMethod" }

    return SoftposResult(
        amount = amount,
        paymentMethod = paymentMethod,
        transactionId = transactionId,
        dateTime = dateTime,
        tid = tid,
        mid = mid,
        isRefund = isRefund
    )
}
