package ru.tbank.posterminal.p2psdk

public sealed interface TransactionData {
    public val amount: Long
    public val paymentMethod: PaymentMethod
    public val mid: Long?
}

public data class PaymentTransactionData(
    override val amount: Long,
    override val paymentMethod: PaymentMethod = PaymentMethod.UNDEFINED,
    override val mid: Long? = null
) : TransactionData

public data class RefundTransactionData(
    override val amount: Long,
    override val paymentMethod: PaymentMethod,
    public val transactionId: Long,
    override val mid: Long
) : TransactionData
