package ru.tinkoff.gatling.kafka.javaapi.request.builder;

import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Expressions;

import java.util.function.Function;

public class ReqRepBase {

    private final String requestName;

    public ReqRepBase(String requestName) {
        this.requestName = requestName;
    }

    public RRInTopicStep requestTopic(String inputTopic) {
        return new RRInTopicStep(Expressions.toStringExpression(inputTopic), this.requestName);
    }

    public RRInTopicStep requestTopic(Function<Session, String> inputTopic){
        return new RRInTopicStep(Expressions.javaFunctionToExpression(inputTopic), this.requestName);
    }
}
