package ru.tinkoff.gatling.kafka.javaapi.request.builder.expressions;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.gatling.javaapi.core.Session;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;

import java.nio.ByteBuffer;
import java.util.function.Function;

public class Builders {
    public Builders() {
    }

    public static final class FloatExpressionBuilder extends ExpressionBuilder<Float> {
        public FloatExpressionBuilder(Function<Session, Float> javaExpression) {
            super(javaExpression, Float.class, Serdes.Float());
        }
    }

    public static final class DoubleExpressionBuilder extends ExpressionBuilder<Double> {
        public DoubleExpressionBuilder(Function<Session, Double> javaExpression) {
            super(javaExpression, Double.class, Serdes.Double());
        }
    }

    public static final class ShortExpressionBuilder extends ExpressionBuilder<Short> {
        public ShortExpressionBuilder(Function<Session, Short> javaExpression) {
            super(javaExpression, Short.class, Serdes.Short());
        }
    }

    public static final class IntegerExpressionBuilder extends ExpressionBuilder<Integer> {
        public IntegerExpressionBuilder(Function<Session, Integer> javaExpression) {
            super(javaExpression, Integer.class, Serdes.Integer());
        }
    }

    public static final class LongExpressionBuilder extends ExpressionBuilder<Long> {
        public LongExpressionBuilder(Function<Session, Long> javaExpression) {
            super(javaExpression, Long.class, Serdes.Long());
        }
    }

    public static final class ByteArrayExpressionBuilder extends ExpressionBuilder<byte[]> {
        public ByteArrayExpressionBuilder(Function<Session, byte[]> javaExpression) {
            super(javaExpression, byte[].class, Serdes.ByteArray());
        }
    }

    public static final class ByteBufferExpressionBuilder extends ExpressionBuilder<ByteBuffer> {
        public ByteBufferExpressionBuilder(Function<Session, ByteBuffer> javaExpression) {
            super(javaExpression, ByteBuffer.class, Serdes.ByteBuffer());
        }
    }

    public static final class BytesExpressionBuilder extends ExpressionBuilder<Bytes> {
        public BytesExpressionBuilder(Function<Session, Bytes> javaExpression) {
            super(javaExpression, Bytes.class, Serdes.Bytes());
        }
    }

    public static final class StringExpressionBuilder extends ExpressionBuilder<String> {
        public StringExpressionBuilder(Function<Session, String> javaExpression) {
            super(javaExpression, String.class, Serdes.String());
        }
    }

    public static final class AvroExpressionBuilder extends ExpressionBuilder<Object> {
        public AvroExpressionBuilder(Function<Session, Object> valueF, SchemaRegistryClient client) {
            super(valueF, Object.class, Serdes.serdeFrom(new KafkaAvroSerializer(client), new KafkaAvroDeserializer(client)));
        }
    }

}
