/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.gatling.kafka.javaapi;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.gatling.commons.validation.Validation;
import io.gatling.core.check.Check;
import io.gatling.core.check.CheckBuilder;
import io.gatling.core.check.CheckMaterializer;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Expressions;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.common.utils.Bytes;
import ru.tinkoff.gatling.kafka.Predef;
import ru.tinkoff.gatling.kafka.javaapi.checks.KafkaCheckType;
import ru.tinkoff.gatling.kafka.javaapi.checks.KafkaChecks;
import ru.tinkoff.gatling.kafka.javaapi.protocol.KafkaProtocolBuilderBase;
import ru.tinkoff.gatling.kafka.javaapi.request.builder.KafkaRequestBuilderBase;
import ru.tinkoff.gatling.kafka.javaapi.request.builder.expressions.Builders;
import ru.tinkoff.gatling.kafka.javaapi.request.builder.expressions.ExpressionBuilder;
import ru.tinkoff.gatling.kafka.request.KafkaProtocolMessage;
import scala.Function1;

public final class KafkaDsl {
    public static <I, T> Function<I, T> cf(T t) {
        return object2 -> t;
    }

    public static ExpressionBuilder<String> stringExp(Function<Session, String> function) {
        return new Builders.StringExpressionBuilder(function);
    }

    public static ExpressionBuilder<String> stringExp(String string) {
        return KafkaDsl.stringExp(KafkaDsl.cf(string));
    }

    public static ExpressionBuilder<Float> floatExp(Function<Session, Float> function) {
        return new Builders.FloatExpressionBuilder(function);
    }

    public static ExpressionBuilder<Float> floatExp(Float f) {
        return KafkaDsl.floatExp(KafkaDsl.cf(f));
    }

    public static ExpressionBuilder<Double> doubleExp(Function<Session, Double> function) {
        return new Builders.DoubleExpressionBuilder(function);
    }

    public static ExpressionBuilder<Double> doubleExp(Double d) {
        return KafkaDsl.doubleExp(KafkaDsl.cf(d));
    }

    public static ExpressionBuilder<Short> shortExp(Function<Session, Short> function) {
        return new Builders.ShortExpressionBuilder(function);
    }

    public static ExpressionBuilder<Short> shortExp(Short s) {
        return KafkaDsl.shortExp(KafkaDsl.cf(s));
    }

    public static ExpressionBuilder<Integer> integerExp(Function<Session, Integer> function) {
        return new Builders.IntegerExpressionBuilder(function);
    }

    public static ExpressionBuilder<Integer> integerExp(Integer n) {
        return KafkaDsl.integerExp(KafkaDsl.cf(n));
    }

    public static ExpressionBuilder<Long> longExp(Function<Session, Long> function) {
        return new Builders.LongExpressionBuilder(function);
    }

    public static ExpressionBuilder<Long> longExp(Long l) {
        return KafkaDsl.longExp(KafkaDsl.cf(l));
    }

    public static ExpressionBuilder<ByteBuffer> byteBufferExp(Function<Session, ByteBuffer> function) {
        return new Builders.ByteBufferExpressionBuilder(function);
    }

    public static ExpressionBuilder<ByteBuffer> byteBufferExp(ByteBuffer byteBuffer) {
        return KafkaDsl.byteBufferExp(KafkaDsl.cf(byteBuffer));
    }

    public static ExpressionBuilder<byte[]> byteArrayExp(byte[] byArray) {
        return KafkaDsl.byteArrayExp(KafkaDsl.cf(byArray));
    }

    public static ExpressionBuilder<byte[]> byteArrayExp(Function<Session, byte[]> function) {
        return new Builders.ByteArrayExpressionBuilder(function);
    }

    public static ExpressionBuilder<Bytes> bytesExp(Function<Session, Bytes> function) {
        return new Builders.BytesExpressionBuilder(function);
    }

    public static ExpressionBuilder<Bytes> bytesExp(Bytes bytes) {
        return KafkaDsl.bytesExp(KafkaDsl.cf(bytes));
    }

    public static Builders.AvroExpressionBuilder avro(Object object, SchemaRegistryClient schemaRegistryClient) {
        return KafkaDsl.avro(KafkaDsl.cf(object), schemaRegistryClient);
    }

    public static Builders.AvroExpressionBuilder avro(Function<Session, Object> function, SchemaRegistryClient schemaRegistryClient) {
        return new Builders.AvroExpressionBuilder(function, schemaRegistryClient);
    }

    public static KafkaProtocolBuilderBase kafka() {
        return new KafkaProtocolBuilderBase();
    }

    public static KafkaRequestBuilderBase kafka(String string) {
        return new KafkaRequestBuilderBase(Predef.kafka((Function1<io.gatling.core.session.Session, Validation<String>>)Expressions.toStringExpression((String)string)), string);
    }

    public static CheckBuilder simpleCheck(final Function<KafkaProtocolMessage, Boolean> function) {
        return new CheckBuilder(){

            public io.gatling.core.check.CheckBuilder<?, ?> asScala() {
                return new io.gatling.core.check.CheckBuilder<Object, Object>(){

                    public Check<?> build(CheckMaterializer checkMaterializer) {
                        return new KafkaChecks.SimpleChecksScala().simpleCheck((Function1<KafkaProtocolMessage, Object>)((Function1)function::apply));
                    }
                };
            }

            public CheckBuilder.CheckType type() {
                return KafkaCheckType.Simple;
            }
        };
    }

    public static CheckBuilder.Find<Object, KafkaProtocolMessage, GenericRecord> avroBody() {
        return new KafkaChecks.SimpleChecksScala().avroBody(KafkaChecks.avroSerde());
    }
}

