/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.gatling.kafka.javaapi.request.builder.expressions;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.gatling.javaapi.core.Session;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import ru.tinkoff.gatling.kafka.javaapi.request.builder.expressions.ExpressionBuilder;

public class Builders {

    public static final class AvroExpressionBuilder
    extends ExpressionBuilder<Object> {
        public AvroExpressionBuilder(Function<Session, Object> function, SchemaRegistryClient schemaRegistryClient) {
            super(function, Object.class, Serdes.serdeFrom((Serializer)new KafkaAvroSerializer(schemaRegistryClient), (Deserializer)new KafkaAvroDeserializer(schemaRegistryClient)));
        }
    }

    public static final class StringExpressionBuilder
    extends ExpressionBuilder<String> {
        public StringExpressionBuilder(Function<Session, String> function) {
            super(function, String.class, Serdes.String());
        }
    }

    public static final class BytesExpressionBuilder
    extends ExpressionBuilder<Bytes> {
        public BytesExpressionBuilder(Function<Session, Bytes> function) {
            super(function, Bytes.class, Serdes.Bytes());
        }
    }

    public static final class ByteBufferExpressionBuilder
    extends ExpressionBuilder<ByteBuffer> {
        public ByteBufferExpressionBuilder(Function<Session, ByteBuffer> function) {
            super(function, ByteBuffer.class, Serdes.ByteBuffer());
        }
    }

    public static final class ByteArrayExpressionBuilder
    extends ExpressionBuilder<byte[]> {
        public ByteArrayExpressionBuilder(Function<Session, byte[]> function) {
            super(function, byte[].class, Serdes.ByteArray());
        }
    }

    public static final class LongExpressionBuilder
    extends ExpressionBuilder<Long> {
        public LongExpressionBuilder(Function<Session, Long> function) {
            super(function, Long.class, Serdes.Long());
        }
    }

    public static final class IntegerExpressionBuilder
    extends ExpressionBuilder<Integer> {
        public IntegerExpressionBuilder(Function<Session, Integer> function) {
            super(function, Integer.class, Serdes.Integer());
        }
    }

    public static final class ShortExpressionBuilder
    extends ExpressionBuilder<Short> {
        public ShortExpressionBuilder(Function<Session, Short> function) {
            super(function, Short.class, Serdes.Short());
        }
    }

    public static final class DoubleExpressionBuilder
    extends ExpressionBuilder<Double> {
        public DoubleExpressionBuilder(Function<Session, Double> function) {
            super(function, Double.class, Serdes.Double());
        }
    }

    public static final class FloatExpressionBuilder
    extends ExpressionBuilder<Float> {
        public FloatExpressionBuilder(Function<Session, Float> function) {
            super(function, Float.class, Serdes.Float());
        }
    }
}

