/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.invest.openapi.okhttp;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.invest.openapi.Context;
import ru.tinkoff.invest.openapi.exceptions.OpenApiException;
import ru.tinkoff.invest.openapi.exceptions.WrongTokenException;
import ru.tinkoff.invest.openapi.model.rest.Empty;
import ru.tinkoff.invest.openapi.model.rest.Error;
import ru.tinkoff.invest.openapi.model.rest.ErrorPayload;

public abstract class BaseContextImpl
implements Context {
    protected static final TypeReference<Error> errorTypeReference = new TypeReference<Error>(){};
    protected static final TypeReference<Empty> emptyPayloadTypeReference = new TypeReference<Empty>(){};
    protected final String authToken;
    protected final HttpUrl finalUrl;
    protected final OkHttpClient client;
    protected final ObjectMapper mapper;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public BaseContextImpl(@NotNull OkHttpClient client, @NotNull String url, @NotNull String authToken) {
        this.authToken = authToken;
        this.finalUrl = Objects.requireNonNull(HttpUrl.parse((String)url)).newBuilder().addPathSegment(this.getPath()).build();
        this.client = client;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.registerModule((Module)new JavaTimeModule());
        this.mapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
    }

    @NotNull
    protected Request.Builder prepareRequest(@NotNull HttpUrl requestUrl) {
        return new Request.Builder().url(requestUrl).addHeader("Authorization", this.authToken);
    }

    @NotNull
    protected <D> D handleResponse(@NotNull Response response, @NotNull TypeReference<D> tr) throws IOException, OpenApiException {
        switch (response.code()) {
            case 200: {
                InputStream bodyStream = Objects.requireNonNull(response.body()).byteStream();
                return (D)this.mapper.readValue(bodyStream, tr);
            }
            case 401: {
                throw new WrongTokenException();
            }
        }
        InputStream errorStream = Objects.requireNonNull(response.body()).byteStream();
        Error answerBody = (Error)this.mapper.readValue(errorStream, errorTypeReference);
        ErrorPayload error = answerBody.getPayload();
        String message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430, trackingId = " + answerBody.getTrackingId();
        this.logger.error(message);
        throw new OpenApiException(error.getMessage(), error.getCode());
    }
}

