/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.invest.openapi.okhttp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.invest.openapi.MarketContext;
import ru.tinkoff.invest.openapi.exceptions.OpenApiException;
import ru.tinkoff.invest.openapi.model.rest.CandleResolution;
import ru.tinkoff.invest.openapi.model.rest.Candles;
import ru.tinkoff.invest.openapi.model.rest.CandlesResponse;
import ru.tinkoff.invest.openapi.model.rest.MarketInstrumentList;
import ru.tinkoff.invest.openapi.model.rest.MarketInstrumentListResponse;
import ru.tinkoff.invest.openapi.model.rest.Orderbook;
import ru.tinkoff.invest.openapi.model.rest.OrderbookResponse;
import ru.tinkoff.invest.openapi.model.rest.SearchMarketInstrument;
import ru.tinkoff.invest.openapi.model.rest.SearchMarketInstrumentResponse;
import ru.tinkoff.invest.openapi.okhttp.BaseContextImpl;

final class MarketContextImpl
extends BaseContextImpl
implements MarketContext {
    private static final String NOT_FOUND_MESSAGE_CODE = "NOT_FOUND";
    private static final String INSTRUMENT_ERROR_MESSAGE_CODE = "INSTRUMENT_ERROR";
    private static final TypeReference<MarketInstrumentListResponse> instrumentsListTypeReference = new TypeReference<MarketInstrumentListResponse>(){};
    private static final TypeReference<OrderbookResponse> orderbookTypeReference = new TypeReference<OrderbookResponse>(){};
    private static final TypeReference<CandlesResponse> historicalCandlesTypeReference = new TypeReference<CandlesResponse>(){};
    private static final TypeReference<SearchMarketInstrumentResponse> instrumentTypeReference = new TypeReference<SearchMarketInstrumentResponse>(){};

    public MarketContextImpl(@NotNull OkHttpClient client, @NotNull String url, @NotNull String authToken) {
        super(client, url, authToken);
    }

    @NotNull
    public String getPath() {
        return "market";
    }

    @NotNull
    public CompletableFuture<MarketInstrumentList> getMarketStocks() {
        final CompletableFuture<MarketInstrumentList> future = new CompletableFuture<MarketInstrumentList>();
        HttpUrl requestUrl = this.finalUrl.newBuilder().addPathSegment("stocks").build();
        Request request = this.prepareRequest(requestUrl).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                MarketContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    MarketInstrumentListResponse result = (MarketInstrumentListResponse)MarketContextImpl.this.handleResponse(response, instrumentsListTypeReference);
                    future.complete(result.getPayload());
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<MarketInstrumentList> getMarketBonds() {
        final CompletableFuture<MarketInstrumentList> future = new CompletableFuture<MarketInstrumentList>();
        HttpUrl requestUrl = this.finalUrl.newBuilder().addPathSegment("bonds").build();
        Request request = this.prepareRequest(requestUrl).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                MarketContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    MarketInstrumentListResponse result = (MarketInstrumentListResponse)MarketContextImpl.this.handleResponse(response, instrumentsListTypeReference);
                    future.complete(result.getPayload());
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<MarketInstrumentList> getMarketEtfs() {
        final CompletableFuture<MarketInstrumentList> future = new CompletableFuture<MarketInstrumentList>();
        HttpUrl requestUrl = this.finalUrl.newBuilder().addPathSegment("etfs").build();
        Request request = this.prepareRequest(requestUrl).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                MarketContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    MarketInstrumentListResponse result = (MarketInstrumentListResponse)MarketContextImpl.this.handleResponse(response, instrumentsListTypeReference);
                    future.complete(result.getPayload());
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<MarketInstrumentList> getMarketCurrencies() {
        final CompletableFuture<MarketInstrumentList> future = new CompletableFuture<MarketInstrumentList>();
        HttpUrl requestUrl = this.finalUrl.newBuilder().addPathSegment("currencies").build();
        Request request = this.prepareRequest(requestUrl).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                MarketContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    MarketInstrumentListResponse result = (MarketInstrumentListResponse)MarketContextImpl.this.handleResponse(response, instrumentsListTypeReference);
                    future.complete(result.getPayload());
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<Optional<Orderbook>> getMarketOrderbook(@NotNull String figi, int depth) {
        final CompletableFuture<Optional<Orderbook>> future = new CompletableFuture<Optional<Orderbook>>();
        HttpUrl requestUrl = this.finalUrl.newBuilder().addPathSegment("orderbook").addQueryParameter("figi", figi).addQueryParameter("depth", Integer.toString(depth)).build();
        Request request = this.prepareRequest(requestUrl).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                MarketContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    OrderbookResponse result = (OrderbookResponse)MarketContextImpl.this.handleResponse(response, orderbookTypeReference);
                    future.complete(Optional.of(result.getPayload()));
                }
                catch (OpenApiException ex) {
                    if (ex.getCode().equals(MarketContextImpl.INSTRUMENT_ERROR_MESSAGE_CODE)) {
                        future.complete(Optional.empty());
                    } else {
                        future.completeExceptionally(ex);
                    }
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<Optional<Candles>> getMarketCandles(@NotNull String figi, @NotNull OffsetDateTime from, @NotNull OffsetDateTime to, @NotNull CandleResolution interval) {
        String renderedInterval;
        final CompletableFuture<Optional<Candles>> future = new CompletableFuture<Optional<Candles>>();
        try {
            renderedInterval = this.mapper.writeValueAsString((Object)interval);
            renderedInterval = renderedInterval.substring(1, renderedInterval.length() - 1);
        }
        catch (JsonProcessingException ex) {
            future.completeExceptionally(ex);
            return future;
        }
        HttpUrl requestUrl = this.finalUrl.newBuilder().addPathSegment("candles").addQueryParameter("figi", figi).addQueryParameter("from", from.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)).addQueryParameter("to", to.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)).addQueryParameter("interval", renderedInterval).build();
        Request request = this.prepareRequest(requestUrl).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                MarketContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    CandlesResponse result = (CandlesResponse)MarketContextImpl.this.handleResponse(response, historicalCandlesTypeReference);
                    future.complete(Optional.of(result.getPayload()));
                }
                catch (OpenApiException ex) {
                    if (ex.getCode().equals(MarketContextImpl.INSTRUMENT_ERROR_MESSAGE_CODE)) {
                        future.complete(Optional.empty());
                    } else {
                        future.completeExceptionally(ex);
                    }
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<MarketInstrumentList> searchMarketInstrumentsByTicker(@NotNull String ticker) {
        final CompletableFuture<MarketInstrumentList> future = new CompletableFuture<MarketInstrumentList>();
        HttpUrl requestUrl = this.finalUrl.newBuilder().addPathSegment("search").addPathSegment("by-ticker").addQueryParameter("ticker", ticker).build();
        Request request = this.prepareRequest(requestUrl).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                MarketContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    MarketInstrumentListResponse result = (MarketInstrumentListResponse)MarketContextImpl.this.handleResponse(response, instrumentsListTypeReference);
                    future.complete(result.getPayload());
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<Optional<SearchMarketInstrument>> searchMarketInstrumentByFigi(@NotNull String figi) {
        final CompletableFuture<Optional<SearchMarketInstrument>> future = new CompletableFuture<Optional<SearchMarketInstrument>>();
        HttpUrl requestUrl = this.finalUrl.newBuilder().addPathSegment("search").addPathSegment("by-figi").addQueryParameter("figi", figi).build();
        Request request = this.prepareRequest(requestUrl).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                MarketContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    SearchMarketInstrumentResponse result = (SearchMarketInstrumentResponse)MarketContextImpl.this.handleResponse(response, instrumentTypeReference);
                    future.complete(Optional.of(result.getPayload()));
                }
                catch (OpenApiException ex) {
                    if (ex.getCode().equals(MarketContextImpl.NOT_FOUND_MESSAGE_CODE)) {
                        future.complete(Optional.empty());
                    } else {
                        future.completeExceptionally(ex);
                    }
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }
}

