/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.invest.openapi.okhttp;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.invest.openapi.MarketContext;
import ru.tinkoff.invest.openapi.OpenApi;
import ru.tinkoff.invest.openapi.OperationsContext;
import ru.tinkoff.invest.openapi.OrdersContext;
import ru.tinkoff.invest.openapi.PortfolioContext;
import ru.tinkoff.invest.openapi.SandboxContext;
import ru.tinkoff.invest.openapi.StreamingContext;
import ru.tinkoff.invest.openapi.UserContext;
import ru.tinkoff.invest.openapi.okhttp.MarketContextImpl;
import ru.tinkoff.invest.openapi.okhttp.OperationsContextImpl;
import ru.tinkoff.invest.openapi.okhttp.OrdersContextImpl;
import ru.tinkoff.invest.openapi.okhttp.PortfolioContextImpl;
import ru.tinkoff.invest.openapi.okhttp.SandboxContextImpl;
import ru.tinkoff.invest.openapi.okhttp.StreamingContextImpl;
import ru.tinkoff.invest.openapi.okhttp.UserContextImpl;

public final class OkHttpOpenApi
extends OpenApi {
    private final Executor executor;
    private final OkHttpClient client;
    private final String apiUrl;
    private SandboxContext sandboxContext;
    private OrdersContext ordersContext;
    private PortfolioContext portfolioContext;
    private MarketContext marketContext;
    private OperationsContext operationsContext;
    private UserContext userContext;
    private StreamingContext streamingContext;

    public OkHttpOpenApi(@NotNull String token, boolean sandboxMode, @NotNull Executor executor) {
        super(token, sandboxMode);
        this.executor = executor;
        this.client = new OkHttpClient.Builder().pingInterval(Duration.ofSeconds(5L)).build();
        this.apiUrl = sandboxMode ? this.config.sandboxApiUrl : this.config.marketApiUrl;
    }

    public OkHttpOpenApi(@NotNull String token, boolean sandboxMode) {
        this(token, sandboxMode, ForkJoinPool.commonPool());
    }

    public void close() {
        this.client.dispatcher().executorService().shutdownNow();
    }

    @NotNull
    public SandboxContext getSandboxContext() {
        if (this.isSandboxMode) {
            if (this.sandboxContext == null) {
                this.sandboxContext = new SandboxContextImpl(this.client, this.apiUrl, this.authToken);
            }
            return this.sandboxContext;
        }
        throw new RuntimeException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u043e\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c\u0441\u044f \"\u043f\u0435\u0441\u043e\u0447\u043d\u044b\u043c\" \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u043e\u043c API \u043d\u0435 \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \"\u043f\u0435\u0441\u043e\u0447\u043d\u0438\u0446\u044b\"");
    }

    @NotNull
    public OrdersContext getOrdersContext() {
        if (this.ordersContext == null) {
            this.ordersContext = new OrdersContextImpl(this.client, this.apiUrl, this.authToken);
        }
        return this.ordersContext;
    }

    @NotNull
    public PortfolioContext getPortfolioContext() {
        if (Objects.isNull(this.portfolioContext)) {
            this.portfolioContext = new PortfolioContextImpl(this.client, this.apiUrl, this.authToken);
        }
        return this.portfolioContext;
    }

    @NotNull
    public MarketContext getMarketContext() {
        if (this.marketContext == null) {
            this.marketContext = new MarketContextImpl(this.client, this.apiUrl, this.authToken);
        }
        return this.marketContext;
    }

    @NotNull
    public OperationsContext getOperationsContext() {
        if (this.operationsContext == null) {
            this.operationsContext = new OperationsContextImpl(this.client, this.apiUrl, this.authToken);
        }
        return this.operationsContext;
    }

    @NotNull
    public UserContext getUserContext() {
        if (this.userContext == null) {
            this.userContext = new UserContextImpl(this.client, this.apiUrl, this.authToken);
        }
        return this.userContext;
    }

    @NotNull
    public StreamingContext getStreamingContext() {
        if (this.streamingContext == null) {
            this.streamingContext = new StreamingContextImpl(this.client, this.config.streamingUrl, this.authToken, this.config.streamingParallelism, this.executor);
        }
        return this.streamingContext;
    }
}

