/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.invest.openapi.okhttp;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.invest.openapi.OperationsContext;
import ru.tinkoff.invest.openapi.model.rest.Operations;
import ru.tinkoff.invest.openapi.model.rest.OperationsResponse;
import ru.tinkoff.invest.openapi.okhttp.BaseContextImpl;

final class OperationsContextImpl
extends BaseContextImpl
implements OperationsContext {
    private static final TypeReference<OperationsResponse> operationsListTypeReference = new TypeReference<OperationsResponse>(){};

    public OperationsContextImpl(@NotNull OkHttpClient client, @NotNull String url, @NotNull String authToken) {
        super(client, url, authToken);
    }

    @NotNull
    public String getPath() {
        return "operations";
    }

    @NotNull
    public CompletableFuture<Operations> getOperations(@NotNull OffsetDateTime from, @NotNull OffsetDateTime to, @Nullable String figi, @Nullable String brokerAccountId) {
        final CompletableFuture<Operations> future = new CompletableFuture<Operations>();
        HttpUrl.Builder builder = this.finalUrl.newBuilder();
        if (Objects.nonNull(figi) && !figi.isEmpty()) {
            builder.addQueryParameter("figi", figi);
        }
        if (Objects.nonNull(brokerAccountId) && !brokerAccountId.isEmpty()) {
            builder.addQueryParameter("brokerAccountId", brokerAccountId);
        }
        HttpUrl requestUrl = builder.addQueryParameter("from", from.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)).addQueryParameter("to", to.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)).build();
        Request request = this.prepareRequest(requestUrl).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                OperationsContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    OperationsResponse result = (OperationsResponse)OperationsContextImpl.this.handleResponse(response, operationsListTypeReference);
                    future.complete(result.getPayload());
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }
}

