/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.invest.openapi.okhttp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.invest.openapi.OrdersContext;
import ru.tinkoff.invest.openapi.exceptions.NotEnoughBalanceException;
import ru.tinkoff.invest.openapi.exceptions.OpenApiException;
import ru.tinkoff.invest.openapi.exceptions.OrderAlreadyCancelledException;
import ru.tinkoff.invest.openapi.model.rest.LimitOrderRequest;
import ru.tinkoff.invest.openapi.model.rest.LimitOrderResponse;
import ru.tinkoff.invest.openapi.model.rest.MarketOrderRequest;
import ru.tinkoff.invest.openapi.model.rest.MarketOrderResponse;
import ru.tinkoff.invest.openapi.model.rest.Order;
import ru.tinkoff.invest.openapi.model.rest.OrdersResponse;
import ru.tinkoff.invest.openapi.model.rest.PlacedLimitOrder;
import ru.tinkoff.invest.openapi.model.rest.PlacedMarketOrder;
import ru.tinkoff.invest.openapi.okhttp.BaseContextImpl;

final class OrdersContextImpl
extends BaseContextImpl
implements OrdersContext {
    private static final String NOT_ENOUGH_BALANCE_CODE = "NOT_ENOUGH_BALANCE";
    private static final String ORDER_ERROR_CODE = "ORDER_ERROR";
    private static final TypeReference<OrdersResponse> listOrderTypeReference = new TypeReference<OrdersResponse>(){};
    private static final TypeReference<LimitOrderResponse> placedLimitOrderTypeReference = new TypeReference<LimitOrderResponse>(){};
    private static final TypeReference<MarketOrderResponse> placedMarketOrderTypeReference = new TypeReference<MarketOrderResponse>(){};

    public OrdersContextImpl(@NotNull OkHttpClient client, @NotNull String url, @NotNull String authToken) {
        super(client, url, authToken);
    }

    @NotNull
    public String getPath() {
        return "orders";
    }

    @NotNull
    public CompletableFuture<List<Order>> getOrders(@Nullable String brokerAccountId) {
        final CompletableFuture<List<Order>> future = new CompletableFuture<List<Order>>();
        HttpUrl.Builder builder = this.finalUrl.newBuilder();
        if (Objects.nonNull(brokerAccountId) && !brokerAccountId.isEmpty()) {
            builder.addQueryParameter("brokerAccountId", brokerAccountId);
        }
        HttpUrl requestUrl = builder.build();
        Request request = this.prepareRequest(requestUrl).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                OrdersContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    OrdersResponse result = (OrdersResponse)OrdersContextImpl.this.handleResponse(response, listOrderTypeReference);
                    future.complete(result.getPayload());
                }
                catch (OpenApiException ex) {
                    if (ex.getCode().equals(OrdersContextImpl.NOT_ENOUGH_BALANCE_CODE)) {
                        future.completeExceptionally((Throwable)new NotEnoughBalanceException(ex.getMessage(), ex.getCode()));
                    } else {
                        future.completeExceptionally(ex);
                    }
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<PlacedLimitOrder> placeLimitOrder(@NotNull String figi, @NotNull LimitOrderRequest limitOrder, @Nullable String brokerAccountId) {
        String renderedBody;
        final CompletableFuture<PlacedLimitOrder> future = new CompletableFuture<PlacedLimitOrder>();
        try {
            renderedBody = this.mapper.writeValueAsString((Object)limitOrder);
        }
        catch (JsonProcessingException ex) {
            future.completeExceptionally(ex);
            return future;
        }
        HttpUrl.Builder builder = this.finalUrl.newBuilder();
        if (Objects.nonNull(brokerAccountId) && !brokerAccountId.isEmpty()) {
            builder.addQueryParameter("brokerAccountId", brokerAccountId);
        }
        HttpUrl requestUrl = builder.addPathSegment("limit-order").addQueryParameter("figi", figi).build();
        Request request = this.prepareRequest(requestUrl).post(RequestBody.create((String)renderedBody, (MediaType)MediaType.get((String)"application/json"))).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                OrdersContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    LimitOrderResponse result = (LimitOrderResponse)OrdersContextImpl.this.handleResponse(response, placedLimitOrderTypeReference);
                    future.complete(result.getPayload());
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<PlacedMarketOrder> placeMarketOrder(@NotNull String figi, @NotNull MarketOrderRequest marketOrder, @Nullable String brokerAccountId) {
        String renderedBody;
        final CompletableFuture<PlacedMarketOrder> future = new CompletableFuture<PlacedMarketOrder>();
        try {
            renderedBody = this.mapper.writeValueAsString((Object)marketOrder);
        }
        catch (JsonProcessingException ex) {
            future.completeExceptionally(ex);
            return future;
        }
        HttpUrl.Builder builder = this.finalUrl.newBuilder();
        if (Objects.nonNull(brokerAccountId) && !brokerAccountId.isEmpty()) {
            builder.addQueryParameter("brokerAccountId", brokerAccountId);
        }
        HttpUrl requestUrl = builder.addPathSegment("market-order").addQueryParameter("figi", figi).build();
        Request request = this.prepareRequest(requestUrl).post(RequestBody.create((String)renderedBody, (MediaType)MediaType.get((String)"application/json"))).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                OrdersContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    MarketOrderResponse result = (MarketOrderResponse)OrdersContextImpl.this.handleResponse(response, placedMarketOrderTypeReference);
                    future.complete(result.getPayload());
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<Void> cancelOrder(@NotNull String orderId, @Nullable String brokerAccountId) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        HttpUrl.Builder builder = this.finalUrl.newBuilder();
        if (Objects.nonNull(brokerAccountId) && !brokerAccountId.isEmpty()) {
            builder.addQueryParameter("brokerAccountId", brokerAccountId);
        }
        HttpUrl requestUrl = builder.addPathSegment("cancel").addQueryParameter("orderId", orderId).build();
        Request request = this.prepareRequest(requestUrl).post(RequestBody.create((byte[])new byte[0])).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                OrdersContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    OrdersContextImpl.this.handleResponse(response, BaseContextImpl.emptyPayloadTypeReference);
                    future.complete(null);
                }
                catch (OpenApiException ex) {
                    if (ex.getCode().equals(OrdersContextImpl.ORDER_ERROR_CODE)) {
                        future.completeExceptionally((Throwable)new OrderAlreadyCancelledException(ex.getMessage(), ex.getCode()));
                    } else {
                        future.completeExceptionally(ex);
                    }
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }
}

