/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.invest.openapi.okhttp;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.invest.openapi.PortfolioContext;
import ru.tinkoff.invest.openapi.model.rest.Currencies;
import ru.tinkoff.invest.openapi.model.rest.Portfolio;
import ru.tinkoff.invest.openapi.model.rest.PortfolioCurrenciesResponse;
import ru.tinkoff.invest.openapi.model.rest.PortfolioResponse;
import ru.tinkoff.invest.openapi.okhttp.BaseContextImpl;

final class PortfolioContextImpl
extends BaseContextImpl
implements PortfolioContext {
    private static final TypeReference<PortfolioResponse> portfolioTypeReference = new TypeReference<PortfolioResponse>(){};
    private static final TypeReference<PortfolioCurrenciesResponse> portfolioCurrenciesTypeReference = new TypeReference<PortfolioCurrenciesResponse>(){};

    public PortfolioContextImpl(@NotNull OkHttpClient client, @NotNull String url, @NotNull String authToken) {
        super(client, url, authToken);
    }

    @NotNull
    public String getPath() {
        return "portfolio";
    }

    @NotNull
    public CompletableFuture<Portfolio> getPortfolio(@Nullable String brokerAccountId) {
        final CompletableFuture<Portfolio> future = new CompletableFuture<Portfolio>();
        HttpUrl.Builder builder = this.finalUrl.newBuilder();
        if (Objects.nonNull(brokerAccountId) && !brokerAccountId.isEmpty()) {
            builder.addQueryParameter("brokerAccountId", brokerAccountId);
        }
        HttpUrl requestUrl = builder.build();
        Request request = this.prepareRequest(requestUrl).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                PortfolioContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    PortfolioResponse result = (PortfolioResponse)PortfolioContextImpl.this.handleResponse(response, portfolioTypeReference);
                    future.complete(result.getPayload());
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<Currencies> getPortfolioCurrencies(@Nullable String brokerAccountId) {
        final CompletableFuture<Currencies> future = new CompletableFuture<Currencies>();
        HttpUrl.Builder builder = this.finalUrl.newBuilder();
        if (Objects.nonNull(brokerAccountId) && !brokerAccountId.isEmpty()) {
            builder.addQueryParameter("brokerAccountId", brokerAccountId);
        }
        HttpUrl requestUrl = builder.addPathSegment("currencies").build();
        Request request = this.prepareRequest(requestUrl).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                PortfolioContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    PortfolioCurrenciesResponse result = (PortfolioCurrenciesResponse)PortfolioContextImpl.this.handleResponse(response, portfolioCurrenciesTypeReference);
                    future.complete(result.getPayload());
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }
}

