/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.invest.openapi.okhttp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.invest.openapi.SandboxContext;
import ru.tinkoff.invest.openapi.model.rest.SandboxAccount;
import ru.tinkoff.invest.openapi.model.rest.SandboxRegisterRequest;
import ru.tinkoff.invest.openapi.model.rest.SandboxRegisterResponse;
import ru.tinkoff.invest.openapi.model.rest.SandboxSetCurrencyBalanceRequest;
import ru.tinkoff.invest.openapi.model.rest.SandboxSetPositionBalanceRequest;
import ru.tinkoff.invest.openapi.okhttp.BaseContextImpl;

final class SandboxContextImpl
extends BaseContextImpl
implements SandboxContext {
    private static final TypeReference<SandboxRegisterResponse> sandboxRegisterResponseReference = new TypeReference<SandboxRegisterResponse>(){};

    public SandboxContextImpl(@NotNull OkHttpClient client, @NotNull String url, @NotNull String authToken) {
        super(client, url, authToken);
    }

    @NotNull
    public String getPath() {
        return "sandbox";
    }

    @NotNull
    public CompletableFuture<SandboxAccount> performRegistration(@NotNull SandboxRegisterRequest registerRequest) {
        String renderedBody;
        final CompletableFuture<SandboxAccount> future = new CompletableFuture<SandboxAccount>();
        HttpUrl requestUrl = this.finalUrl.newBuilder().addPathSegment("register").build();
        try {
            renderedBody = this.mapper.writeValueAsString((Object)registerRequest);
        }
        catch (JsonProcessingException ex) {
            future.completeExceptionally(ex);
            return future;
        }
        RequestBody requestBody = RequestBody.create((String)renderedBody, (MediaType)MediaType.get((String)"application/json"));
        Request request = this.prepareRequest(requestUrl).post(requestBody).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                SandboxContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    SandboxRegisterResponse result = (SandboxRegisterResponse)SandboxContextImpl.this.handleResponse(response, sandboxRegisterResponseReference);
                    future.complete(result.getPayload());
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<Void> setCurrencyBalance(@NotNull SandboxSetCurrencyBalanceRequest balanceRequest, @Nullable String brokerAccountId) {
        String renderedBody;
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            renderedBody = this.mapper.writeValueAsString((Object)balanceRequest);
        }
        catch (JsonProcessingException ex) {
            future.completeExceptionally(ex);
            return future;
        }
        HttpUrl.Builder builder = this.finalUrl.newBuilder();
        if (Objects.nonNull(brokerAccountId) && !brokerAccountId.isEmpty()) {
            builder.addQueryParameter("brokerAccountId", brokerAccountId);
        }
        HttpUrl requestUrl = builder.addPathSegment("currencies").addPathSegment("balance").build();
        Request request = this.prepareRequest(requestUrl).post(RequestBody.create((String)renderedBody, (MediaType)MediaType.get((String)"application/json"))).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                SandboxContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    SandboxContextImpl.this.handleResponse(response, BaseContextImpl.emptyPayloadTypeReference);
                    future.complete(null);
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<Void> setPositionBalance(@NotNull SandboxSetPositionBalanceRequest balanceRequest, @Nullable String brokerAccountId) {
        String renderedBody;
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            renderedBody = this.mapper.writeValueAsString((Object)balanceRequest);
        }
        catch (JsonProcessingException ex) {
            future.completeExceptionally(ex);
            return future;
        }
        HttpUrl.Builder builder = this.finalUrl.newBuilder();
        if (Objects.nonNull(brokerAccountId) && !brokerAccountId.isEmpty()) {
            builder.addQueryParameter("brokerAccountId", brokerAccountId);
        }
        HttpUrl requestUrl = builder.addPathSegment("positions").addPathSegment("balance").build();
        Request request = this.prepareRequest(requestUrl).post(RequestBody.create((String)renderedBody, (MediaType)MediaType.get((String)"application/json"))).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                SandboxContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    SandboxContextImpl.this.handleResponse(response, BaseContextImpl.emptyPayloadTypeReference);
                    future.complete(null);
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<Void> removeAccount(@Nullable String brokerAccountId) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        HttpUrl.Builder builder = this.finalUrl.newBuilder();
        if (Objects.nonNull(brokerAccountId) && !brokerAccountId.isEmpty()) {
            builder.addQueryParameter("brokerAccountId", brokerAccountId);
        }
        HttpUrl requestUrl = builder.addPathSegment("remove").build();
        Request request = this.prepareRequest(requestUrl).post(RequestBody.create((byte[])new byte[0])).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                SandboxContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    SandboxContextImpl.this.handleResponse(response, BaseContextImpl.emptyPayloadTypeReference);
                    future.complete(null);
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }

    @NotNull
    public CompletableFuture<Void> clearAll(@Nullable String brokerAccountId) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        HttpUrl.Builder builder = this.finalUrl.newBuilder();
        if (Objects.nonNull(brokerAccountId) && !brokerAccountId.isEmpty()) {
            builder.addQueryParameter("brokerAccountId", brokerAccountId);
        }
        HttpUrl requestUrl = builder.addPathSegment("clear").build();
        Request request = this.prepareRequest(requestUrl).post(RequestBody.create((byte[])new byte[0])).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                SandboxContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    SandboxContextImpl.this.handleResponse(response, BaseContextImpl.emptyPayloadTypeReference);
                    future.complete(null);
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }
}

