/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.invest.openapi.okhttp;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.invest.openapi.UserContext;
import ru.tinkoff.invest.openapi.model.rest.UserAccounts;
import ru.tinkoff.invest.openapi.model.rest.UserAccountsResponse;
import ru.tinkoff.invest.openapi.okhttp.BaseContextImpl;

final class UserContextImpl
extends BaseContextImpl
implements UserContext {
    private static final TypeReference<UserAccountsResponse> accountsListTypeReference = new TypeReference<UserAccountsResponse>(){};

    public UserContextImpl(@NotNull OkHttpClient client, @NotNull String url, @NotNull String authToken) {
        super(client, url, authToken);
    }

    @NotNull
    public String getPath() {
        return "user";
    }

    @NotNull
    public CompletableFuture<UserAccounts> getAccounts() {
        final CompletableFuture<UserAccounts> future = new CompletableFuture<UserAccounts>();
        HttpUrl requestUrl = this.finalUrl.newBuilder().addPathSegment("accounts").build();
        Request request = this.prepareRequest(requestUrl).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                UserContextImpl.this.logger.error("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043a REST API \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e);
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    UserAccountsResponse result = (UserAccountsResponse)UserContextImpl.this.handleResponse(response, accountsListTypeReference);
                    future.complete(result.getPayload());
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }
        });
        return future;
    }
}

