/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.annotation.processor.common;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.annotation.processor.common.TagUtils;
import ru.tinkoff.kora.common.AopAnnotation;
import ru.tinkoff.kora.common.Mapping;
import ru.tinkoff.kora.common.NamingStrategy;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.common.naming.NameConverter;

public class CommonUtils {
    public static String decapitalize(String s) {
        char firstChar = s.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return s;
        }
        return Character.toLowerCase(firstChar) + s.substring(1);
    }

    public static String capitalize(String s) {
        char firstChar = s.charAt(0);
        if (Character.isUpperCase(firstChar)) {
            return s;
        }
        return Character.toUpperCase(firstChar) + s.substring(1);
    }

    public static boolean isNullable(AnnotatedConstruct element) {
        boolean isNullable = element.getAnnotationMirrors().stream().anyMatch(a -> a.getAnnotationType().toString().endsWith(".Nullable"));
        if (isNullable) {
            return true;
        }
        if (element instanceof ExecutableElement) {
            ExecutableElement method = (ExecutableElement)element;
            if (method.getReturnType().getKind().isPrimitive()) {
                return false;
            }
            return CommonUtils.isNullable(method.getReturnType());
        }
        if (element instanceof VariableElement) {
            VariableElement ve = (VariableElement)element;
            TypeMirror type = ve.asType();
            if (type.getKind().isPrimitive()) {
                return false;
            }
            return CommonUtils.isNullable(type);
        }
        if (element instanceof RecordComponentElement) {
            RecordComponentElement rce = (RecordComponentElement)element;
            return rce.getEnclosingElement().getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD).filter(e -> e.getSimpleName().contentEquals(rce.getSimpleName())).anyMatch(CommonUtils::isNullable);
        }
        return false;
    }

    public static void safeWriteTo(ProcessingEnvironment processingEnv, JavaFile file) {
        try {
            file.writeTo(processingEnv.getFiler());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<ExecutableElement> findConstructors(TypeElement typeElement, Predicate<Set<Modifier>> modifiersFilter) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (Element element : typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.CONSTRUCTOR || !modifiersFilter.test(element.getModifiers())) continue;
            result.add((ExecutableElement)element);
        }
        return result;
    }

    public static boolean hasDefaultConstructorAndFinal(Types types, TypeMirror typeMirror) {
        TypeElement typeElement = (TypeElement)types.asElement(typeMirror);
        return CommonUtils.hasDefaultConstructorAndFinal(typeElement);
    }

    public static boolean hasDefaultConstructorAndFinal(TypeElement typeElement) {
        if (!typeElement.getModifiers().contains((Object)Modifier.FINAL)) {
            return false;
        }
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement constructor;
            if (element.getKind() != ElementKind.CONSTRUCTOR || !(constructor = (ExecutableElement)element).getModifiers().contains((Object)Modifier.PUBLIC) || !constructor.getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static List<ExecutableElement> findMethods(TypeElement typeElement, Predicate<Set<Modifier>> modifiersFilter) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (Element element : typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !modifiersFilter.test(element.getModifiers())) continue;
            result.add((ExecutableElement)element);
        }
        return result;
    }

    public static boolean doesImplement(TypeMirror type, ClassName i) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        DeclaredType declaredType = (DeclaredType)type;
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            TypeName interfaceType = TypeName.get((TypeMirror)typeMirror);
            if (!(interfaceType instanceof ParameterizedTypeName)) continue;
            ParameterizedTypeName ptn = (ParameterizedTypeName)interfaceType;
            if (!ptn.rawType.equals((Object)i)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static AnnotationSpec toTagAnnotation(Set<String> t) {
        if (t == null || t.isEmpty()) {
            return null;
        }
        CodeBlock.Builder tags = CodeBlock.builder().add("{", new Object[0]);
        Iterator<String> i = t.iterator();
        while (i.hasNext()) {
            String tag = i.next();
            tags.add("$L.class", new Object[]{tag});
            if (!i.hasNext()) continue;
            tags.add(", ", new Object[0]);
        }
        tags.add("}", new Object[0]);
        return AnnotationSpec.builder(Tag.class).addMember("value", tags.build()).build();
    }

    public static MappersData parseMapping(Element element) {
        Set<String> tag = TagUtils.parseTagValue(element);
        if (((Mapping[])element.getAnnotationsByType(Mapping.class)).length == 0 && tag.isEmpty()) {
            return new MappersData(null, tag);
        }
        List<TypeMirror> mapping = Stream.of((Mapping[])element.getAnnotationsByType(Mapping.class)).map(m -> {
            try {
                m.value();
                throw new IllegalStateException();
            }
            catch (MirroredTypeException e) {
                return e.getTypeMirror();
            }
        }).collect(Collectors.toList());
        return new MappersData(mapping, tag);
    }

    @Nullable
    public static Class<?> getNamingStrategyConverterClass(Element element) {
        DeclaredType dt;
        Element element2;
        AnnotationMirror annotation = AnnotationUtils.findAnnotation(element, CommonClassNames.namingStrategy);
        if (annotation == null) {
            return null;
        }
        List typeMirrors = (List)AnnotationUtils.parseAnnotationValueWithoutDefault(annotation, "value");
        if (typeMirrors == null || typeMirrors.isEmpty()) {
            return null;
        }
        TypeMirror mirror = (TypeMirror)typeMirrors.get(0);
        if (mirror instanceof DeclaredType && (element2 = (dt = (DeclaredType)mirror).asElement()) instanceof TypeElement) {
            TypeElement te = (TypeElement)element2;
            String className = te.getQualifiedName().toString();
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new ProcessingErrorException("Class " + className + " not found in classpath", element);
            }
        }
        return null;
    }

    public static NameConverter getNameConverter(NameConverter defaultValue, TypeElement typeElement) {
        NameConverter converter = CommonUtils.getNameConverter(typeElement);
        if (converter != null) {
            return converter;
        }
        return defaultValue;
    }

    @Nullable
    public static NameConverter getNameConverter(TypeElement typeElement) {
        Class<?> namingStrategyClass;
        NamingStrategy namingStrategy = typeElement.getAnnotation(NamingStrategy.class);
        NameConverter nameConverter = null;
        if (namingStrategy != null && (namingStrategyClass = CommonUtils.getNamingStrategyConverterClass(typeElement)) != null) {
            try {
                nameConverter = (NameConverter)namingStrategyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new ProcessingErrorException("Error on calling name converter constructor " + typeElement, typeElement);
            }
        }
        return nameConverter;
    }

    public static TypeSpec.Builder extendsKeepAop(TypeElement type, String newName) {
        TypeSpec.Builder b = TypeSpec.classBuilder((String)newName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addOriginatingElement((Element)type);
        if (type.getKind() == ElementKind.INTERFACE) {
            b.addSuperinterface(type.asType());
        } else {
            b.superclass(type.asType());
        }
        boolean hasAop = false;
        for (AnnotationMirror annotationMirror : type.getAnnotationMirrors()) {
            if (!CommonUtils.isAopAnnotation(annotationMirror)) continue;
            b.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
            hasAop = true;
        }
        if (!hasAop && !CommonUtils.hasAopAnnotations(type)) {
            b.addModifiers(new Modifier[]{Modifier.FINAL});
        }
        return b;
    }

    public static MethodSpec.Builder overridingKeepAop(ExecutableElement method) {
        ExecutableType type = (ExecutableType)method.asType();
        return CommonUtils.overridingKeepAop(method, type);
    }

    public static MethodSpec.Builder overridingKeepAop(ExecutableElement method, ExecutableType methodType) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)method.getSimpleName().toString());
        if (method.getModifiers().contains((Object)Modifier.PUBLIC)) {
            methodBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        if (method.getModifiers().contains((Object)Modifier.PROTECTED)) {
            methodBuilder.addModifiers(new Modifier[]{Modifier.PROTECTED});
        }
        for (TypeParameterElement typeParameterElement : method.getTypeParameters()) {
            TypeVariable var = (TypeVariable)typeParameterElement.asType();
            methodBuilder.addTypeVariable(TypeVariableName.get((TypeVariable)var));
        }
        methodBuilder.addAnnotation(Override.class);
        for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
            if (!CommonUtils.isAopAnnotation(annotationMirror) && !annotationMirror.getAnnotationType().toString().endsWith(".Nullable")) continue;
            methodBuilder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
        }
        methodBuilder.returns(TypeName.get((TypeMirror)methodType.getReturnType()));
        for (int i = 0; i < method.getParameters().size(); ++i) {
            VariableElement variableElement = method.getParameters().get(i);
            TypeMirror parameterType = methodType.getParameterTypes().get(i);
            String name = parameterType.toString().startsWith("kotlin.coroutines.Continuation") ? "_continuation" : variableElement.getSimpleName().toString();
            ParameterSpec.Builder pb = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)parameterType), (String)name, (Modifier[])new Modifier[0]);
            for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                if (!CommonUtils.isAopAnnotation(annotationMirror) && !annotationMirror.getAnnotationType().toString().endsWith(".Nullable")) continue;
                pb.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
            }
            methodBuilder.addParameter(pb.build());
        }
        methodBuilder.varargs(method.isVarArgs());
        for (TypeMirror typeMirror : methodType.getThrownTypes()) {
            methodBuilder.addException(TypeName.get((TypeMirror)typeMirror));
        }
        return methodBuilder;
    }

    public static boolean hasAopAnnotations(TypeElement typeElement) {
        if (CommonUtils.hasAopAnnotation(typeElement)) {
            return true;
        }
        List<ExecutableElement> methods = CommonUtils.findMethods(typeElement, m -> m.contains((Object)Modifier.PUBLIC) || m.contains((Object)Modifier.PROTECTED));
        for (ExecutableElement method : methods) {
            if (CommonUtils.hasAopAnnotation(method)) {
                return true;
            }
            for (VariableElement variableElement : method.getParameters()) {
                if (!CommonUtils.hasAopAnnotation(variableElement)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasAopAnnotation(Element e) {
        return e.getAnnotationMirrors().stream().anyMatch(CommonUtils::isAopAnnotation);
    }

    private static boolean isAopAnnotation(AnnotationMirror am) {
        return am.getAnnotationType().asElement().getAnnotation(AopAnnotation.class) != null;
    }

    public static boolean isVoid(TypeMirror returnType) {
        if (returnType.getKind() == TypeKind.NONE || returnType.getKind() == TypeKind.VOID) {
            return true;
        }
        String typeAsStr = returnType.toString();
        return Void.class.getCanonicalName().equals(typeAsStr) || "void".equals(typeAsStr);
    }

    public static boolean isList(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        if (!(type instanceof DeclaredType)) {
            return false;
        }
        DeclaredType dt = (DeclaredType)type;
        String name = dt.asElement().toString();
        return name.equals(List.class.getCanonicalName()) || name.equals(ArrayList.class.getCanonicalName()) || name.equals(LinkedList.class.getCanonicalName());
    }

    public static boolean isSet(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        if (!(type instanceof DeclaredType)) {
            return false;
        }
        DeclaredType dt = (DeclaredType)type;
        String name = dt.asElement().toString();
        return name.equals(Set.class.getCanonicalName()) || name.equals(HashSet.class.getCanonicalName()) || name.equals(TreeSet.class.getCanonicalName()) || name.equals(SortedSet.class.getCanonicalName()) || name.equals(LinkedHashSet.class.getCanonicalName()) || name.equals(CopyOnWriteArraySet.class.getCanonicalName()) || name.equals(ConcurrentSkipListSet.class.getCanonicalName());
    }

    public static boolean isQueue(TypeMirror type) {
        DeclaredType dt;
        return type.getKind() == TypeKind.DECLARED && type instanceof DeclaredType && ((dt = (DeclaredType)type).asElement().toString().equals(Queue.class.getCanonicalName()) || dt.asElement().toString().equals(Deque.class.getCanonicalName()));
    }

    public static boolean isCollection(TypeMirror type) {
        DeclaredType dt;
        return type.getKind() == TypeKind.DECLARED && type instanceof DeclaredType && ((dt = (DeclaredType)type).asElement().toString().equals(Collection.class.getCanonicalName()) || CommonUtils.isList(type) || CommonUtils.isSet(type) || CommonUtils.isQueue(type));
    }

    public static boolean isMap(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        if (!(type instanceof DeclaredType)) {
            return false;
        }
        DeclaredType dt = (DeclaredType)type;
        String name = dt.asElement().toString();
        return name.equals(Map.class.getCanonicalName()) || name.equals(HashMap.class.getCanonicalName()) || name.equals(TreeMap.class.getCanonicalName()) || name.equals(LinkedHashMap.class.getCanonicalName()) || name.equals(ConcurrentMap.class.getCanonicalName()) || name.equals(ConcurrentHashMap.class.getCanonicalName()) || name.equals(SortedMap.class.getCanonicalName()) || name.equals(NavigableMap.class.getCanonicalName()) || name.equals(ConcurrentSkipListMap.class.getCanonicalName()) || name.equals(IdentityHashMap.class.getCanonicalName()) || name.equals(WeakHashMap.class.getCanonicalName()) || name.equals(EnumMap.class.getCanonicalName());
    }

    public static boolean isOptional(TypeMirror type) {
        DeclaredType dt;
        return type.getKind() == TypeKind.DECLARED && type instanceof DeclaredType && (dt = (DeclaredType)type).asElement().toString().equals(Optional.class.getCanonicalName());
    }

    public static boolean isMono(TypeMirror type) {
        DeclaredType dt;
        return type.getKind() == TypeKind.DECLARED && type instanceof DeclaredType && (dt = (DeclaredType)type).asElement().toString().equals(CommonClassNames.mono.canonicalName());
    }

    public static boolean isFlux(TypeMirror type) {
        DeclaredType dt;
        return type.getKind() == TypeKind.DECLARED && type instanceof DeclaredType && (dt = (DeclaredType)type).asElement().toString().equals(CommonClassNames.flux.canonicalName());
    }

    public static boolean isPublisher(TypeMirror type) {
        DeclaredType dt;
        return type.getKind() == TypeKind.DECLARED && type instanceof DeclaredType && (dt = (DeclaredType)type).asElement().toString().equals(CommonClassNames.publisher.canonicalName());
    }

    public static boolean isFuture(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        if (!(type instanceof DeclaredType)) {
            return false;
        }
        DeclaredType dt = (DeclaredType)type;
        String name = dt.asElement().toString();
        return name.equals(CompletableFuture.class.getCanonicalName()) || name.equals(CompletionStage.class.getCanonicalName());
    }

    public record MappersData(@Nullable List<TypeMirror> mapperClasses, Set<String> mapperTags) {
        @Nullable
        public MappingData getMapping(Types types, TypeMirror type) {
            if (this.mapperClasses == null && this.mapperTags.isEmpty()) {
                return null;
            }
            for (TypeMirror mapperClass : Objects.requireNonNullElse(this.mapperClasses, List.of())) {
                if (!types.isAssignable(mapperClass, type)) continue;
                return new MappingData(mapperClass, this.mapperTags);
            }
            if (this.mapperTags.isEmpty()) {
                return null;
            }
            return new MappingData(null, this.mapperTags);
        }

        @Nullable
        public MappingData getMapping(ClassName type) {
            if (this.mapperClasses == null) {
                return null;
            }
            for (TypeMirror mapperClass : this.mapperClasses) {
                if (!CommonUtils.doesImplement(mapperClass, type)) continue;
                return new MappingData(mapperClass, this.mapperTags);
            }
            if (this.mapperTags.isEmpty()) {
                return null;
            }
            return new MappingData(null, this.mapperTags);
        }

        public boolean isEmpty() {
            return this.mapperTags == null && (this.mapperClasses == null || this.mapperClasses.isEmpty());
        }

        @Nullable
        public MappingData first() {
            if (this.isEmpty()) {
                return null;
            }
            if (this.mapperClasses == null || this.mapperClasses.isEmpty()) {
                return new MappingData(null, this.mapperTags);
            }
            return new MappingData(this.mapperClasses.get(0), this.mapperTags);
        }
    }

    public record MappingData(@Nullable TypeMirror mapperClass, Set<String> mapperTags) {
        @Nullable
        public AnnotationSpec toTagAnnotation() {
            return CommonUtils.toTagAnnotation(this.mapperTags);
        }

        public boolean isGeneric() {
            TypeElement te;
            DeclaredType dt;
            AnnotatedConstruct annotatedConstruct = this.mapperClass;
            return annotatedConstruct instanceof DeclaredType && (annotatedConstruct = (dt = (DeclaredType)annotatedConstruct).asElement()) instanceof TypeElement && !(te = (TypeElement)annotatedConstruct).getTypeParameters().isEmpty();
        }

        public ParameterizedTypeName parameterized(TypeName tn) {
            DeclaredType dt;
            assert (this.isGeneric());
            AnnotatedConstruct annotatedConstruct = this.mapperClass;
            if (annotatedConstruct instanceof DeclaredType && (annotatedConstruct = (dt = (DeclaredType)annotatedConstruct).asElement()) instanceof TypeElement) {
                TypeElement te = (TypeElement)annotatedConstruct;
                return ParameterizedTypeName.get((ClassName)ClassName.get((TypeElement)te), (TypeName[])new TypeName[]{tn});
            }
            throw new IllegalStateException();
        }
    }
}

