/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.annotation.processor.common;

import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;

public final class MethodUtils {
    private MethodUtils() {
    }

    public static boolean isMono(ExecutableElement method) {
        return CommonUtils.isMono(method.getReturnType());
    }

    public static boolean isFuture(ExecutableElement method) {
        return CommonUtils.isFuture(method.getReturnType());
    }

    public static boolean isFlux(ExecutableElement method) {
        return CommonUtils.isFlux(method.getReturnType());
    }

    public static boolean isVoid(ExecutableElement method) {
        return CommonUtils.isVoid(method.getReturnType());
    }

    public static boolean isMonoVoid(ExecutableElement method) {
        return MethodUtils.isMono(method) && MethodUtils.getGenericType(method.getReturnType()).filter(CommonUtils::isVoid).isPresent();
    }

    public static boolean isFutureVoid(ExecutableElement method) {
        return MethodUtils.isFuture(method) && MethodUtils.getGenericType(method.getReturnType()).filter(CommonUtils::isVoid).isPresent();
    }

    public static boolean isOptional(ExecutableElement method) {
        return CommonUtils.isOptional(method.getReturnType());
    }

    public static boolean isPublisher(ExecutableElement method) {
        return CommonUtils.isPublisher(method.getReturnType());
    }

    public static boolean isVoidGeneric(TypeMirror returnType) {
        if (returnType instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)returnType;
            return CommonUtils.isVoid(dt.getTypeArguments().get(0));
        }
        return false;
    }

    public static boolean isVoidGeneric(ExecutableElement method) {
        TypeMirror typeMirror = method.getReturnType();
        if (typeMirror instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)typeMirror;
            return CommonUtils.isVoid(dt.getTypeArguments().get(0));
        }
        return false;
    }

    public static Optional<TypeMirror> getGenericType(TypeMirror typeMirror) {
        if (typeMirror instanceof DeclaredType) {
            return ((DeclaredType)typeMirror).getTypeArguments().stream().map(v -> v).findFirst();
        }
        return Optional.empty();
    }
}

