/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.annotation.processor.common;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import ru.tinkoff.kora.annotation.processor.common.ProcessingError;

public class ProcessingErrorException
extends RuntimeException {
    private final List<ProcessingError> errors;

    public ProcessingErrorException(List<ProcessingError> errors) {
        super(ProcessingErrorException.toMessage(errors));
        this.errors = errors;
    }

    public ProcessingErrorException(ProcessingError error) {
        this(List.of(error));
    }

    public ProcessingErrorException(String message, Element element, AnnotationMirror a, AnnotationValue v) {
        this(List.of(new ProcessingError(Diagnostic.Kind.ERROR, message, element, a, v)));
    }

    public ProcessingErrorException(String message, Element element, AnnotationMirror a) {
        this(List.of(new ProcessingError(message, element, a)));
    }

    public ProcessingErrorException(String message, Element element) {
        this(List.of(new ProcessingError(message, element)));
    }

    private static String toMessage(List<ProcessingError> errors) {
        return errors.stream().map(ProcessingError::message).collect(Collectors.joining("\n"));
    }

    public List<ProcessingError> getErrors() {
        return this.errors;
    }

    public static ProcessingErrorException merge(List<ProcessingErrorException> exceptions) {
        List<ProcessingError> errors = exceptions.stream().map(ProcessingErrorException::getErrors).flatMap(Collection::stream).toList();
        ProcessingErrorException exception = new ProcessingErrorException(errors);
        for (ProcessingErrorException processingErrorException : exceptions) {
            exception.addSuppressed(processingErrorException);
        }
        return exception;
    }

    public void printError(ProcessingEnvironment processingEnv) {
        this.printError(0, processingEnv);
    }

    private void printError(int indent, ProcessingEnvironment processingEnv) {
        for (ProcessingError error : this.errors) {
            error.print(indent, processingEnv);
        }
        for (Throwable supressed : this.getSuppressed()) {
            if (!(supressed instanceof ProcessingErrorException)) continue;
            ProcessingErrorException e = (ProcessingErrorException)supressed;
            e.printError(indent + 6, processingEnv);
        }
    }
}

