/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.annotation.processor.common;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.tools.JavaFileObject;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;

public class RecordClassBuilder {
    private final Class<?> origin;
    public final String name;
    public final Set<Modifier> modifiers = new HashSet<Modifier>();
    public final List<RecordComponent> components = new ArrayList<RecordComponent>();
    public final List<TypeName> interfaces = new ArrayList<TypeName>();
    public final List<Element> originatingElements = new ArrayList<Element>();
    private boolean enforceEquals = false;
    private CodeBlock defaultConstructorBody;

    public RecordClassBuilder(String name, Class<?> origin) {
        this.name = name;
        this.origin = origin;
    }

    public RecordClassBuilder defaultConstructorBody(CodeBlock defaultConstructorBody) {
        this.defaultConstructorBody = defaultConstructorBody;
        return this;
    }

    public RecordClassBuilder enforceEquals() {
        this.enforceEquals = true;
        return this;
    }

    public RecordClassBuilder addModifier(Modifier modifier) {
        this.modifiers.add(modifier);
        return this;
    }

    public RecordClassBuilder addComponent(String name, TypeName type, List<AnnotationSpec> annotations) {
        this.components.add(new RecordComponent(name, type, annotations, null, false));
        return this;
    }

    public RecordClassBuilder addComponent(String name, TypeName type) {
        this.components.add(new RecordComponent(name, type, List.of(), null, false));
        return this;
    }

    public RecordClassBuilder addComponent(String name, TypeName type, CodeBlock defaultValue) {
        this.components.add(new RecordComponent(name, type, List.of(), defaultValue, false));
        return this;
    }

    public RecordClassBuilder addComponent(String name, TypeName type, boolean checkNotNull) {
        this.components.add(new RecordComponent(name, type, List.of(), null, checkNotNull));
        return this;
    }

    public RecordClassBuilder superinterface(TypeName type) {
        this.interfaces.add(type);
        return this;
    }

    public RecordClassBuilder originatingElement(Element element) {
        this.originatingElements.add(element);
        return this;
    }

    public String render() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("@").append(CommonClassNames.koraGenerated.canonicalName()).append("(\"").append(this.origin.getCanonicalName()).append("\")").append("\n");
        for (Modifier modifier : this.modifiers) {
            sb.append(modifier.toString()).append(' ');
        }
        sb.append("record ").append(this.name).append("(\n");
        for (i = 0; i < this.components.size(); ++i) {
            RecordComponent component = this.components.get(i);
            for (AnnotationSpec annotation : component.annotations) {
                sb.append("  ").append(annotation.toString()).append("\n");
            }
            if (component.defaultValue != null) {
                boolean hasNullable = component.annotations.stream().anyMatch(a -> a.type.toString().endsWith(".Nullable"));
                if (!hasNullable) {
                    sb.append("  @jakarta.annotation.Nullable ");
                }
            } else if (component.notNullCheck && !component.type.isPrimitive()) {
                sb.append("  @jakarta.annotation.Nonnull ");
            } else {
                sb.append("  ");
            }
            sb.append(component.type.toString()).append(" ").append(component.name);
            if (i < this.components.size() - 1) {
                sb.append(',');
            }
            sb.append("\n");
        }
        sb.append(")");
        if (!this.interfaces.isEmpty()) {
            sb.append(" implements ");
            for (i = 0; i < this.interfaces.size(); ++i) {
                TypeName anInterface = this.interfaces.get(i);
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(anInterface.toString());
            }
        }
        sb.append(" {\n");
        sb.append("  public ").append(this.name).append(" {\n");
        for (RecordComponent component : this.components) {
            if (component.defaultValue != null) {
                sb.append("    if (").append(component.name).append(" == null) ").append(component.name).append(" = ").append(component.defaultValue.toString()).append(";\n");
                continue;
            }
            if (!component.notNullCheck || component.type.isPrimitive()) continue;
            sb.append("    ").append(Objects.class.getCanonicalName()).append(".requireNonNull(").append(component.name).append(");\n");
        }
        if (this.defaultConstructorBody != null) {
            sb.append(this.defaultConstructorBody.toString().indent(4));
            sb.append("\n  }\n");
        } else {
            sb.append("  }\n");
        }
        if (this.enforceEquals && this.components.stream().anyMatch(f -> f.type() instanceof ArrayTypeName)) {
            sb.append("    @Override\n");
            sb.append("    public boolean equals(Object o) {\n");
            sb.append("      return this == o || o instanceof ").append(this.name).append(" that\n");
            for (RecordComponent component : this.components) {
                if (component.type() instanceof ArrayTypeName) {
                    sb.append("        && java.util.Arrays.equals(this.").append(component.name()).append("(), that.").append(component.name()).append("())\n");
                    continue;
                }
                if (component.type.isPrimitive()) {
                    sb.append("        && this.").append(component.name()).append("() == that.").append(component.name()).append("()\n");
                    continue;
                }
                sb.append("        && java.util.Objects.equals(this.").append(component.name()).append("(), that.").append(component.name()).append("())\n");
            }
            sb.append("      ;\n");
            sb.append("    }\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public String toString() {
        return this.render();
    }

    public void writeTo(Filer filer, String packageName) throws IOException {
        JavaFileObject configFile = filer.createSourceFile(packageName + "." + this.name, (Element[])this.originatingElements.toArray(Element[]::new));
        try (Writer w = configFile.openWriter();){
            w.write("package ");
            w.write(packageName);
            w.write(";\n\n");
            w.write(this.render());
        }
    }

    public record RecordComponent(String name, TypeName type, List<AnnotationSpec> annotations, CodeBlock defaultValue, boolean notNullCheck) {
    }
}

