/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.annotation.processor.common;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;

public class AnnotationUtils {
    public static AnnotationSpec generated(String canonicalName) {
        return AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", "$S", new Object[]{canonicalName}).build();
    }

    public static AnnotationSpec generated(Class<?> generator) {
        return AnnotationUtils.generated(generator.getCanonicalName());
    }

    @Nullable
    public static AnnotationMirror findAnnotation(Element element, Predicate<String> namePredicate) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String name = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
            if (!namePredicate.test(name)) continue;
            return annotationMirror;
        }
        return null;
    }

    @Nullable
    public static AnnotationMirror findAnnotation(Element element, ClassName name) {
        List<AnnotationMirror> list = AnnotationUtils.findAnnotations(element, name, null);
        if (list.isEmpty()) {
            return null;
        }
        return Objects.requireNonNull(list.get(0));
    }

    @Nullable
    public static AnnotationMirror findAnnotation(Elements elements, Element element, ClassName name) {
        List<AnnotationMirror> list = AnnotationUtils.findAnnotations(elements, element, name, null);
        if (list.isEmpty()) {
            return null;
        }
        return Objects.requireNonNull(list.get(0));
    }

    public static boolean isAnnotationPresent(Element element, ClassName name) {
        return !AnnotationUtils.findAnnotations(element, name, null).isEmpty();
    }

    public static List<AnnotationMirror> findAnnotations(Element element, ClassName name, @Nullable ClassName containerName) {
        ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationType = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (annotationType.getQualifiedName().contentEquals(name.canonicalName())) {
                result.add(annotationMirror);
            }
            if (containerName == null || !annotationType.getQualifiedName().contentEquals(containerName.canonicalName())) continue;
            List value = (List)AnnotationUtils.parseAnnotationValueWithoutDefault(annotationMirror, "value");
            for (AnnotationValue annotationValue : value) {
                AnnotationMirror am = (AnnotationMirror)annotationValue.getValue();
                result.add(am);
            }
        }
        return result;
    }

    public static List<AnnotationMirror> findAnnotations(Elements elements, Element element, ClassName name, @Nullable ClassName containerName) {
        ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : elements.getAllAnnotationMirrors(element)) {
            TypeElement annotationType = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (annotationType.getQualifiedName().contentEquals(name.canonicalName())) {
                result.add(annotationMirror);
            }
            if (containerName == null || !annotationType.getQualifiedName().contentEquals(containerName.canonicalName())) continue;
            List value = (List)AnnotationUtils.parseAnnotationValueWithoutDefault(annotationMirror, "value");
            for (AnnotationValue annotationValue : value) {
                AnnotationMirror am = (AnnotationMirror)annotationValue.getValue();
                result.add(am);
            }
        }
        return result;
    }

    @Nullable
    public static <T> T parseAnnotationValue(Elements elements, @Nullable AnnotationMirror annotationMirror, String name) {
        if (annotationMirror == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> annotationValues = elements.getElementValuesWithDefaults(annotationMirror);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationValues.entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(name)) continue;
            AnnotationValue value = entry.getValue();
            if (value == null) {
                return null;
            }
            Object finalValue = value.getValue();
            return (T)finalValue;
        }
        return null;
    }

    @Nullable
    public static <T> T parseAnnotationValueWithoutDefault(@Nullable AnnotationMirror annotationMirror, String name) {
        if (annotationMirror == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> annotationValues = annotationMirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationValues.entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(name)) continue;
            AnnotationValue value = entry.getValue();
            if (value == null) {
                return null;
            }
            Object annotationValue = value.getValue();
            if (annotationValue instanceof List) {
                List list = (List)annotationValue;
                List<Object> finalValue = list.stream().map(AnnotationValue.class::cast).map(AnnotationValue::getValue).toList();
                return (T)finalValue;
            }
            Object finalValue = value.getValue();
            return (T)finalValue;
        }
        return null;
    }
}

