/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.annotation.processor.common;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildEnvironment {
    public static final Logger log = LoggerFactory.getLogger((String)"ru.tinkoff.kora");
    private static final AtomicBoolean INIT = new AtomicBoolean(false);
    private static Path buildDir = Paths.get(".", new String[0]);

    public static synchronized void init(ProcessingEnvironment processingEnv) {
        block5: {
            if (!INIT.compareAndSet(false, true)) {
                return;
            }
            try {
                FileObject resource = processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "", "out");
                Path sourceOutput = Paths.get(resource.toUri()).toAbsolutePath().getParent();
                Path dir = sourceOutput.getParent();
                if (dir.getFileName().toString().equals("java")) {
                    buildDir = dir.getParent().getParent().getParent().getParent();
                    break block5;
                }
                if (dir.getFileName().toString().startsWith("generated-")) {
                    buildDir = dir.getParent();
                    break block5;
                }
                return;
            }
            catch (IOException e) {
                return;
            }
        }
        BuildEnvironment.initLog(processingEnv);
    }

    private static void initLog(ProcessingEnvironment processingEnv) {
        if (!(LoggerFactory.getILoggerFactory() instanceof LoggerContext)) {
            return;
        }
        LoggerContext ctx = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger kora = ctx.getLogger("ru.tinkoff.kora");
        kora.setAdditive(false);
        kora.detachAndStopAllAppenders();
        ConsoleAppender consoleAppender = new ConsoleAppender();
        FileAppender fileAppender = new FileAppender();
        String fileName = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'hh-mm-ss").format(LocalDateTime.now()) + ".log";
        fileAppender.setFile(buildDir.resolve("kora").resolve("log").resolve(fileName).toString());
        PatternLayoutEncoder patternLayoutEncoder = new PatternLayoutEncoder();
        patternLayoutEncoder.setPattern("%d{HH:mm:ss.SSS} %-5level [%thread] %logger{36} - %msg%n");
        patternLayoutEncoder.setCharset(StandardCharsets.UTF_8);
        patternLayoutEncoder.setContext((Context)ctx);
        patternLayoutEncoder.start();
        fileAppender.setEncoder((Encoder)patternLayoutEncoder);
        fileAppender.setContext((Context)ctx);
        fileAppender.start();
        consoleAppender.setEncoder((Encoder)patternLayoutEncoder);
        consoleAppender.setContext((Context)ctx);
        consoleAppender.start();
        kora.addAppender((Appender)fileAppender);
        kora.addAppender((Appender)consoleAppender);
        Logger logger = log;
        if (logger instanceof ch.qos.logback.classic.Logger) {
            ch.qos.logback.classic.Logger logger2 = (ch.qos.logback.classic.Logger)logger;
            logger2.setLevel(Level.valueOf((String)processingEnv.getOptions().getOrDefault("koraLogLevel", "INFO")));
        }
    }
}

