/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.annotation.processor.common;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MethodAssertUtils {
    public static void assertHasMethod(Class<?> type, String name, Type returnType, Type ... params) {
        List<Method> methods = Arrays.stream(type.getMethods()).filter(m -> m.getName().equals(name)).toList();
        if (methods.isEmpty()) {
            throw new AssertionError((Object)("Type " + type + " was expected to have method " + name + "(" + Arrays.stream(params).map(Objects::toString).collect(Collectors.joining()) + ") but no method with that name found"));
        }
        for (Method method : methods) {
            Type actual;
            Type expected;
            if (method.getParameters().length != params.length) continue;
            if (!method.getGenericReturnType().equals(returnType)) break;
            Type[] parameterTypes = method.getGenericParameterTypes();
            for (int i = 0; i < params.length && (expected = params[i]).equals(actual = parameterTypes[i]); ++i) {
            }
            return;
        }
        throw new AssertionError((Object)("Type " + type + " was expected to have method " + name + "(" + Arrays.stream(params).map(Objects::toString).collect(Collectors.joining()) + ") but no method with same parameters found"));
    }
}

