/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.annotation.processor.common;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;

public final class TagUtils {
    private TagUtils() {
    }

    private static Set<String> parseTagValue0(AnnotatedConstruct element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType type = annotationMirror.getAnnotationType();
            if (type.toString().equals(CommonClassNames.tag.canonicalName())) {
                return Objects.requireNonNull((List)AnnotationUtils.parseAnnotationValueWithoutDefault(annotationMirror, "value")).stream().map(TypeMirror::toString).collect(Collectors.toSet());
            }
            Element annotationElement = type.asElement();
            for (AnnotationMirror annotationMirror2 : annotationElement.getAnnotationMirrors()) {
                DeclaredType annotationType = annotationMirror2.getAnnotationType();
                if (!annotationType.toString().equals(CommonClassNames.tag.canonicalName())) continue;
                return Objects.requireNonNull((List)AnnotationUtils.parseAnnotationValueWithoutDefault(annotationMirror2, "value")).stream().map(TypeMirror::toString).collect(Collectors.toSet());
            }
        }
        if (element instanceof ArrayType) {
            ArrayType array = (ArrayType)element;
            return TagUtils.parseTagValue0(array.getComponentType());
        }
        return Set.of();
    }

    public static Set<String> parseTagValue(AnnotatedConstruct construct) {
        Set<String> tag = TagUtils.parseTagValue0(construct);
        if (!tag.isEmpty()) {
            return tag;
        }
        if (!(construct instanceof Element)) {
            return tag;
        }
        Element element = (Element)construct;
        if (element.getEnclosingElement().getKind() == ElementKind.RECORD) {
            if (element.getKind() == ElementKind.FIELD) {
                for (Element element2 : element.getEnclosingElement().getEnclosedElements()) {
                    if (element2.getKind() != ElementKind.RECORD_COMPONENT || !element2.getSimpleName().contentEquals(element.getSimpleName())) continue;
                    RecordComponentElement recordComponentElement = (RecordComponentElement)element2;
                    tag = TagUtils.parseTagValue0(recordComponentElement);
                    if (tag.isEmpty()) {
                        return TagUtils.parseTagValue0(recordComponentElement.getAccessor());
                    }
                    return tag;
                }
            }
            if (element.getKind() == ElementKind.RECORD_COMPONENT) {
                RecordComponentElement recordComponent = (RecordComponentElement)element;
                for (Element element3 : element.getEnclosingElement().getEnclosedElements()) {
                    if (element3.getKind() != ElementKind.FIELD || !element3.getSimpleName().contentEquals(element.getSimpleName()) || (tag = TagUtils.parseTagValue0(element3)).isEmpty()) continue;
                    return tag;
                }
                return TagUtils.parseTagValue0(recordComponent.getAccessor());
            }
            if (element.getKind() == ElementKind.METHOD) {
                ExecutableElement method = (ExecutableElement)element;
                if (!method.getParameters().isEmpty()) {
                    return Set.of();
                }
                for (Element element4 : element.getEnclosingElement().getEnclosedElements()) {
                    if (element4.getKind() == ElementKind.FIELD && element4.getSimpleName().contentEquals(element.getSimpleName()) && !(tag = TagUtils.parseTagValue0(element4)).isEmpty()) {
                        return tag;
                    }
                    if (element4.getKind() != ElementKind.RECORD_COMPONENT || !element4.getSimpleName().contentEquals(element.getSimpleName()) || (tag = TagUtils.parseTagValue0(element4)).isEmpty()) continue;
                    return tag;
                }
            }
        }
        return Set.of();
    }

    public static AnnotationSpec makeAnnotationSpecForTypes(TypeName ... tags) {
        AnnotationSpec.Builder annotation = AnnotationSpec.builder((ClassName)CommonClassNames.tag);
        CodeBlock.Builder value = CodeBlock.builder();
        value.add("{", new Object[0]);
        List<TypeName> tagsList = List.of(tags);
        for (int i = 0; i < tagsList.size(); ++i) {
            if (i > 0) {
                value.add(", ", new Object[0]);
            }
            value.add("$T.class", new Object[]{tagsList.get(i)});
        }
        value.add("}", new Object[0]);
        return annotation.addMember("value", value.build()).build();
    }

    public static AnnotationSpec makeAnnotationSpec(Set<String> tags) {
        AnnotationSpec.Builder annotation = AnnotationSpec.builder((ClassName)CommonClassNames.tag);
        CodeBlock.Builder value = CodeBlock.builder();
        value.add("{", new Object[0]);
        ArrayList<String> tagsList = new ArrayList<String>(tags);
        for (int i = 0; i < tagsList.size(); ++i) {
            if (i > 0) {
                value.add(", ", new Object[0]);
            }
            value.add("$L.class", new Object[]{tagsList.get(i)});
        }
        value.add("}", new Object[0]);
        return annotation.addMember("value", value.build()).build();
    }

    public static CodeBlock writeTagAnnotationValue(List<TypeMirror> tag) {
        CodeBlock.Builder b = CodeBlock.builder().add("{", new Object[0]);
        for (TypeMirror typeMirrorValue : tag) {
            b.add("$T.class, ", new Object[]{typeMirrorValue});
        }
        return b.add("}", new Object[0]).build();
    }
}

