/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.annotation.processor.common;

import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;

public class TypeParameterUtils {
    public static boolean hasTypeParameter(TypeMirror typeMirror) {
        return typeMirror.accept(new TypeVisitor<Boolean, Object>(){

            @Override
            public Boolean visit(TypeMirror t, Object o) {
                return null;
            }

            @Override
            public Boolean visitPrimitive(PrimitiveType t, Object o) {
                return false;
            }

            @Override
            public Boolean visitNull(NullType t, Object o) {
                return false;
            }

            @Override
            public Boolean visitArray(ArrayType t, Object o) {
                return t.getComponentType().accept(this, null);
            }

            @Override
            public Boolean visitDeclared(DeclaredType t, Object o) {
                for (TypeMirror typeMirror : t.getTypeArguments()) {
                    if (!typeMirror.accept(this, null).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visitError(ErrorType t, Object o) {
                return false;
            }

            @Override
            public Boolean visitTypeVariable(TypeVariable t, Object o) {
                return true;
            }

            @Override
            public Boolean visitWildcard(WildcardType t, Object o) {
                if (t.getExtendsBound() != null) {
                    return t.getExtendsBound().accept(this, null);
                }
                if (t.getSuperBound() != null) {
                    return t.getSuperBound().accept(this, null);
                }
                return false;
            }

            @Override
            public Boolean visitExecutable(ExecutableType t, Object o) {
                return false;
            }

            @Override
            public Boolean visitNoType(NoType t, Object o) {
                return false;
            }

            @Override
            public Boolean visitUnknown(TypeMirror t, Object o) {
                return false;
            }

            @Override
            public Boolean visitUnion(UnionType t, Object o) {
                return t.getAlternatives().stream().map(tm -> tm.accept(this, null)).reduce(false, (a, b) -> a != false || b != false);
            }

            @Override
            public Boolean visitIntersection(IntersectionType t, Object o) {
                return t.getBounds().stream().map(tm -> tm.accept(this, null)).reduce(false, (a, b) -> a != false || b != false);
            }
        }, null);
    }

    public static boolean hasRawTypes(TypeMirror type) {
        return switch (type.getKind()) {
            case TypeKind.DECLARED -> {
                DeclaredType dt = (DeclaredType)type;
                TypeElement te = (TypeElement)dt.asElement();
                if (!te.getTypeParameters().isEmpty() && dt.getTypeArguments().isEmpty()) {
                    yield true;
                }
                for (TypeMirror var4_4 : dt.getTypeArguments()) {
                    if (!TypeParameterUtils.hasRawTypes(var4_4)) continue;
                    yield true;
                }
                yield false;
            }
            case TypeKind.ARRAY -> TypeParameterUtils.hasRawTypes(((ArrayType)type).getComponentType());
            default -> false;
        };
    }
}

