/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.annotation.processor.common;

import com.squareup.javapoet.ClassName;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import ru.tinkoff.kora.annotation.processor.common.BuildEnvironment;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;

public abstract class AbstractKoraProcessor
extends AbstractProcessor {
    protected Types types;
    protected Elements elements;
    protected Messager messager;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        SourceVersion latestVersion = SourceVersion.latest();
        if (latestVersion.ordinal() >= 17) {
            return latestVersion;
        }
        return SourceVersion.RELEASE_17;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        BuildEnvironment.init(processingEnv);
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public final Set<String> getSupportedAnnotationTypes() {
        return this.getSupportedAnnotationClassNames().stream().map(ClassName::canonicalName).collect(Collectors.toSet());
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        long start = System.currentTimeMillis();
        Set<ClassName> supportedAnnotationNames = this.getSupportedAnnotationClassNames();
        HashMap<ClassName, List<AnnotatedElement>> annotatedElements = new HashMap<ClassName, List<AnnotatedElement>>();
        int annotatedElementsSize = 0;
        for (TypeElement typeElement : annotations) {
            ClassName annotationClassName = ClassName.get((TypeElement)typeElement);
            if (!supportedAnnotationNames.contains(annotationClassName)) continue;
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                annotatedElements.computeIfAbsent(annotationClassName, n -> new ArrayList()).add(new AnnotatedElement(typeElement, element));
                ++annotatedElementsSize;
            }
        }
        try {
            this.process(annotations, roundEnv, annotatedElements);
        }
        catch (ProcessingErrorException e) {
            e.printError(this.processingEnv);
        }
        long end = System.currentTimeMillis();
        long took = end - start;
        if (took > 100L) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, "%s processing took %sms for %d elements".formatted(this.getClass().getSimpleName(), took, annotatedElementsSize));
        }
        return false;
    }

    protected abstract void process(Set<? extends TypeElement> var1, RoundEnvironment var2, Map<ClassName, List<AnnotatedElement>> var3);

    public abstract Set<ClassName> getSupportedAnnotationClassNames();

    @Nullable
    protected TypeElement findRoundAnnotation(Set<? extends TypeElement> roundAnnotation, ClassName className) {
        for (TypeElement typeElement : roundAnnotation) {
            if (!typeElement.getQualifiedName().contentEquals(className.canonicalName())) continue;
            return typeElement;
        }
        return null;
    }

    public record AnnotatedElement(TypeElement annotationType, Element element) {
    }
}

