/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.annotation.processor.common;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.TagUtils;

public class FieldFactory {
    private final Types types;
    private final Elements elements;
    @Nullable
    private final TypeSpec.Builder builder;
    private final MethodSpec.Builder constructor;
    private final Map<FieldKey, String> fields = new HashMap<FieldKey, String>();
    private final String prefix;

    public String get(ClassName mapperType, TypeMirror mappedType, Element element) {
        ParameterizedTypeName type = ParameterizedTypeName.get((ClassName)mapperType, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)mappedType).box()});
        Set<String> tags = TagUtils.parseTagValue(element);
        FieldKey key = new FieldKey((TypeName)type, tags);
        return this.fields.get(key);
    }

    public String get(ClassName mapperType, CommonUtils.MappingData mappingData, TypeMirror type) {
        TypeMirror mapperClass = mappingData.mapperClass();
        if (mapperClass == null) {
            ParameterizedTypeName mapperTypeName = ParameterizedTypeName.get((ClassName)mapperType, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)type).box()});
            return this.fields.get(new FieldKey((TypeName)mapperTypeName, mappingData.mapperTags()));
        }
        TypeName mapperTypeName = TypeName.get((TypeMirror)mapperClass);
        return this.fields.get(new FieldKey(mapperTypeName, mappingData.mapperTags()));
    }

    public FieldFactory(Types types, Elements elements, @Nullable TypeSpec.Builder builder, MethodSpec.Builder constructor, String prefix) {
        this.types = types;
        this.elements = elements;
        this.builder = builder;
        this.constructor = constructor;
        this.prefix = prefix;
    }

    public String add(TypeName typeName, Set<String> tags) {
        FieldKey key = new FieldKey(typeName, tags);
        String existed = this.fields.get(key);
        if (existed != null) {
            return existed;
        }
        String name = this.prefix + (this.fields.size() + 1);
        this.fields.put(key, name);
        if (this.builder != null) {
            this.builder.addField(typeName, name, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            this.constructor.addStatement("this.$N = $N", new Object[]{name, name});
        }
        ParameterSpec.Builder parameter = ParameterSpec.builder((TypeName)typeName, (String)name, (Modifier[])new Modifier[0]);
        AnnotationSpec tag = CommonUtils.toTagAnnotation(tags);
        if (tag != null) {
            parameter.addAnnotation(tag);
        }
        this.constructor.addParameter(parameter.build());
        return name;
    }

    public String add(TypeName typeName, CodeBlock initializer) {
        FieldKey key = new FieldKey(typeName, Set.of());
        String existed = this.fields.get(key);
        if (existed != null) {
            return existed;
        }
        String name = this.prefix + (this.fields.size() + 1);
        this.fields.put(key, name);
        if (this.builder != null) {
            this.builder.addField(typeName, name, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            this.constructor.addStatement("this.$N = $L", new Object[]{name, initializer});
        } else {
            this.constructor.addStatement("var $N = $L", new Object[]{name, initializer});
        }
        return name;
    }

    public String add(TypeMirror typeMirror, Set<String> tags) {
        TypeName typeName = TypeName.get((TypeMirror)typeMirror);
        FieldKey key = new FieldKey(typeName, tags);
        String existed = this.fields.get(key);
        if (existed != null) {
            return existed;
        }
        String name = this.prefix + (this.fields.size() + 1);
        this.fields.put(key, name);
        if (tags.isEmpty() && CommonUtils.hasDefaultConstructorAndFinal(this.types, typeMirror)) {
            if (this.builder != null) {
                this.builder.addField(typeName, name, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                this.constructor.addStatement("this.$N = new $T()", new Object[]{name, typeName});
            } else {
                this.constructor.addStatement("var $N = new $T()", new Object[]{name, typeName});
            }
        } else {
            this.constructor.addParameter(typeName, name, new Modifier[0]);
            if (this.builder != null) {
                this.builder.addField(typeName, name, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                this.constructor.addStatement("this.$N = $N", new Object[]{name, name});
            }
        }
        return name;
    }

    public String add(@Nullable CommonUtils.MappingData mapping, TypeName defaultType) {
        TypeElement typeElement;
        TypeName typeName;
        Set<String> tags = mapping == null ? Set.of() : mapping.mapperTags();
        TypeName typeName2 = typeName = mapping == null ? defaultType : TypeName.get((TypeMirror)Objects.requireNonNull(mapping.mapperClass()));
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName ptn = (ParameterizedTypeName)typeName;
            typeElement = this.elements.getTypeElement(ptn.rawType.canonicalName());
        } else {
            typeElement = this.elements.getTypeElement(((ClassName)typeName).canonicalName());
        }
        TypeElement typeElement2 = typeElement;
        FieldKey key = new FieldKey(typeName, tags);
        String existed = this.fields.get(key);
        if (existed != null) {
            return existed;
        }
        String name = this.prefix + (this.fields.size() + 1);
        this.fields.put(key, name);
        if (tags.isEmpty() && CommonUtils.hasDefaultConstructorAndFinal(typeElement2)) {
            if (this.builder != null) {
                this.builder.addField(typeName, name, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                this.constructor.addStatement("this.$N = new $T()", new Object[]{name, typeName});
            } else {
                this.constructor.addStatement("var $N = new $T()", new Object[]{name, typeName});
            }
        } else {
            ParameterSpec.Builder parameter = ParameterSpec.builder((TypeName)typeName, (String)name, (Modifier[])new Modifier[0]);
            AnnotationSpec tag = CommonUtils.toTagAnnotation(tags);
            if (tag != null) {
                parameter.addAnnotation(tag);
            }
            this.constructor.addParameter(parameter.build());
            if (this.builder != null) {
                this.builder.addField(typeName, name, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                this.constructor.addStatement("this.$N = $N", new Object[]{name, name});
            }
        }
        return name;
    }

    record FieldKey(TypeName typeName, Set<String> tags) {
    }
}

