/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.annotation.processor.common;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.GenericMethod;

public class GenericTypeResolver {
    public static TypeMirror resolve(final Types types, final Map<TypeVariable, TypeMirror> parameters, TypeMirror typeMirror) {
        return typeMirror.accept(new TypeVisitor<TypeMirror, Void>(){

            @Override
            public TypeMirror visit(TypeMirror t, Void unused) {
                return t;
            }

            @Override
            public TypeMirror visitPrimitive(PrimitiveType t, Void unused) {
                return t;
            }

            @Override
            public TypeMirror visitNull(NullType t, Void unused) {
                return t;
            }

            @Override
            public TypeMirror visitArray(ArrayType t, Void unused) {
                TypeMirror componentType = t.getComponentType();
                return types.getArrayType(GenericTypeResolver.resolve(types, parameters, componentType));
            }

            @Override
            public TypeMirror visitDeclared(DeclaredType t, Void unused) {
                List<? extends TypeMirror> typeArguments = t.getTypeArguments();
                TypeMirror[] typeParams = (TypeMirror[])typeArguments.stream().map(arg -> GenericTypeResolver.resolve(types, parameters, arg)).toArray(TypeMirror[]::new);
                for (int i = 0; i < typeParams.length; ++i) {
                    TypeMirror enriched;
                    TypeMirror original = typeArguments.get(i);
                    if (original == (enriched = typeParams[i])) continue;
                    return types.getDeclaredType((TypeElement)types.asElement(t), typeParams);
                }
                return t;
            }

            @Override
            public TypeMirror visitError(ErrorType t, Void unused) {
                return t;
            }

            @Override
            public TypeMirror visitTypeVariable(TypeVariable t, Void unused) {
                return (TypeMirror)parameters.get(t);
            }

            @Override
            public TypeMirror visitWildcard(WildcardType t, Void unused) {
                return t;
            }

            @Override
            public TypeMirror visitExecutable(ExecutableType t, Void unused) {
                TypeMirror enriched;
                TypeMirror original;
                int i;
                TypeMirror returnType = t.getReturnType();
                List<? extends TypeMirror> parameterTypes = t.getParameterTypes();
                TypeMirror receiverType = t.getReceiverType();
                List<? extends TypeMirror> thrownTypes = t.getThrownTypes();
                TypeMirror enrichedReturnType = returnType.accept(this, null);
                List<TypeMirror> enrichedParameterTypes = parameterTypes.stream().map(pt -> pt.accept(this, null)).toList();
                TypeMirror enrichedReceiverType = receiverType != null ? receiverType.accept(this, null) : null;
                List<TypeMirror> enrichedThrownTypes = thrownTypes.stream().map(pt -> pt.accept(this, null)).toList();
                ExecutableElement element = (ExecutableElement)types.asElement(t);
                if (returnType != enrichedReturnType) {
                    return new GenericMethod(element, enrichedReturnType, enrichedParameterTypes, enrichedReceiverType, enrichedThrownTypes);
                }
                for (i = 0; i < parameterTypes.size(); ++i) {
                    original = parameterTypes.get(i);
                    if (original == (enriched = enrichedParameterTypes.get(i))) continue;
                    return new GenericMethod(element, enrichedReturnType, enrichedParameterTypes, enrichedReceiverType, enrichedThrownTypes);
                }
                if (receiverType != enrichedReceiverType) {
                    return new GenericMethod(element, enrichedReturnType, enrichedParameterTypes, enrichedReceiverType, enrichedThrownTypes);
                }
                for (i = 0; i < enrichedThrownTypes.size(); ++i) {
                    original = enrichedThrownTypes.get(i);
                    if (original == (enriched = enrichedThrownTypes.get(i))) continue;
                    return new GenericMethod(element, enrichedReturnType, enrichedParameterTypes, enrichedReceiverType, enrichedThrownTypes);
                }
                return t;
            }

            @Override
            public TypeMirror visitNoType(NoType t, Void unused) {
                return t;
            }

            @Override
            public TypeMirror visitUnknown(TypeMirror t, Void unused) {
                return t;
            }

            @Override
            public TypeMirror visitUnion(UnionType t, Void unused) {
                return t;
            }

            @Override
            public TypeMirror visitIntersection(IntersectionType t, Void unused) {
                return t;
            }
        }, null);
    }
}

